/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.packet;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketRegistry {
    public static final int MAX_PACKET_SIZE = 1000;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Class<?>, Packet<?>> packetClasses = new HashMap();
    private static final BiMap<Byte, Packet<?>> packets = HashBiMap.create();

    public static <MSG> void register(int id, Class<MSG> packetClass, Function<MSG, ByteBuffer> encoder, Function<ByteBuffer, MSG> decoder, BiConsumer<MSG, Supplier<Context>> messageConsumer) {
        PacketRegistry.register((byte)id, packetClass, encoder, decoder, messageConsumer);
    }

    public static <MSG> void register(byte id, Class<MSG> packetClass, Function<MSG, ByteBuffer> encoder, Function<ByteBuffer, MSG> decoder, BiConsumer<MSG, Supplier<Context>> messageConsumer) {
        Packet<MSG> packet = new Packet<MSG>(encoder, decoder, messageConsumer);
        packetClasses.put(packetClass, packet);
        packets.put((Object)id, packet);
    }

    public static <MSG> byte[] encode(MSG message) {
        Packet<?> packet = packetClasses.get(message.getClass());
        if (packet == null) {
            LOGGER.error("The message %s is not registered and cannot be encoded.", (Object)message.toString());
            return null;
        }
        ByteBuffer buffer = packet.encode(message);
        buffer.position(0);
        byte[] array = new byte[buffer.capacity() + 1];
        array[0] = (Byte)packets.inverse().getOrDefault(packet, (Object)-1);
        buffer.get(array, 1, array.length - 1);
        return array;
    }

    public static <MSG> MSG decode(byte[] array, int length) {
        if (array.length == 0) {
            return null;
        }
        Packet packet = (Packet)packets.get((Object)array[0]);
        if (packet == null) {
            LOGGER.error("The message with the id %i is not registered and cannot be decoded.", (Object)array[0]);
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(length - 1);
        buffer.put(array, 1, length - 1);
        buffer.position(0);
        return packet.decode(buffer);
    }

    public static <MSG> void handle(MSG message, Context.Sender sender, InetSocketAddress address) {
        PacketRegistry.handle(message, sender, address, null);
    }

    public static <MSG> void handle(MSG message, Context.Sender sender, InetSocketAddress address, ServerPlayerEntity player) {
        Packet<?> packet = packetClasses.get(message.getClass());
        if (packet == null) {
            LOGGER.error("The message %s is not registered and cannot be handled.", (Object)message.toString());
        }
        try {
            packet.getMessageConsumer().accept(message, () -> new Context(sender, address, player));
        }
        catch (Exception ex) {
            LOGGER.warn("An exception occured while handling the message %s", (Object)message.toString(), (Object)ex);
        }
    }

    public static class Context {
        private final Sender sender;
        private final InetSocketAddress address;
        private final ServerPlayerEntity player;

        public Context(Sender sender, InetSocketAddress address, ServerPlayerEntity player) {
            this.sender = sender;
            this.address = address;
            this.player = player;
        }

        public Sender getSender() {
            return this.sender;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public boolean hasPlayer() {
            return this.player != null;
        }

        public ServerPlayerEntity getPlayer() {
            return this.player;
        }

        public static enum Sender {
            SERVER,
            PLAYER;

        }
    }

    private static class Packet<MSG> {
        private final Function<MSG, ByteBuffer> encoder;
        private final Function<ByteBuffer, MSG> decoder;
        private final BiConsumer<MSG, Supplier<Context>> messageConsumer;

        public Packet(Function<MSG, ByteBuffer> encoder, Function<ByteBuffer, MSG> decoder, BiConsumer<MSG, Supplier<Context>> messageConsumer) {
            this.encoder = encoder;
            this.decoder = decoder;
            this.messageConsumer = messageConsumer;
        }

        public ByteBuffer encode(MSG message) {
            return this.encoder.apply(message);
        }

        public MSG decode(ByteBuffer array) {
            return this.decoder.apply(array);
        }

        public BiConsumer<MSG, Supplier<Context>> getMessageConsumer() {
            return this.messageConsumer;
        }
    }
}

