/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.packet.message;

import info.u_team.voice_chat.init.VoiceChatNetworks;
import info.u_team.voice_chat.message.HandshakeDoneMessage;
import info.u_team.voice_chat.message.PlayerIDMessage;
import info.u_team.voice_chat.packet.PacketRegistry;
import info.u_team.voice_chat.server.VerifiedPlayerManager;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.PacketDistributor;

public class HandshakePacket {
    public static ByteBuffer encode(HandshakePacket message) {
        return ByteBuffer.allocate(0);
    }

    public static HandshakePacket decode(ByteBuffer buffer) {
        return new HandshakePacket();
    }

    public static class Handler {
        public static void handle(HandshakePacket message, Supplier<PacketRegistry.Context> contextSupplier) {
            PacketRegistry.Context context = contextSupplier.get();
            if (!context.hasPlayer()) {
                return;
            }
            ServerPlayerEntity player = context.getPlayer();
            if (!VerifiedPlayerManager.hasPlayerData(player)) {
                VerifiedPlayerManager.PlayerData data = new VerifiedPlayerManager.PlayerData(context.getAddress());
                VerifiedPlayerManager.addPlayer(player, data);
                VoiceChatNetworks.NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new HandshakeDoneMessage());
                VoiceChatNetworks.NETWORK.send(PacketDistributor.ALL.noArg(), (Object)new PlayerIDMessage(false, player.func_110124_au(), data.getId()));
            }
        }
    }
}

