/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.packet.message;

import info.u_team.voice_chat.packet.PacketRegistry;
import info.u_team.voice_chat.packet.message.VoiceToClientPacket;
import info.u_team.voice_chat.server.VerifiedPlayerManager;
import info.u_team.voice_chat.server.VoiceServerManager;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;

public class VoiceToServerPacket {
    private final byte[] opusPacket;

    public VoiceToServerPacket(byte[] opusPacket) {
        this.opusPacket = opusPacket;
    }

    public static ByteBuffer encode(VoiceToServerPacket message) {
        return ByteBuffer.wrap(message.opusPacket);
    }

    public static VoiceToServerPacket decode(ByteBuffer buffer) {
        return new VoiceToServerPacket(buffer.array());
    }

    public static class Handler {
        public static void handle(VoiceToServerPacket message, Supplier<PacketRegistry.Context> contextSupplier) {
            PacketRegistry.Context context = contextSupplier.get();
            if (!context.hasPlayer()) {
                return;
            }
            ServerPlayerEntity player = context.getPlayer();
            VerifiedPlayerManager.PlayerData playerData = VerifiedPlayerManager.getPlayerData(player);
            if (playerData == null) {
                return;
            }
            VoiceServerManager.getServer().sendAllExcept(new VoiceToClientPacket(playerData.getId(), message.opusPacket), player);
        }
    }
}

