/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.util.GuiUtil;
import info.u_team.voice_chat.client.TalkingManager;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderOverlayVoiceChat {
    private static ResourceLocation SPEAKING = new ResourceLocation("voicechat", "textures/gui/speaking.png");

    public static void draw(MatrixStack matrixStack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        AtomicInteger counter = new AtomicInteger();
        TalkingManager.getTalkers().stream().map(RenderOverlayVoiceChat::getName).forEach(name -> RenderOverlayVoiceChat.drawEntry(matrixStack, 5, 5 + counter.getAndIncrement() * 8, minecraft, fontRenderer, name));
    }

    public static void drawEntry(MatrixStack stack, int x, int y, Minecraft minecraft, FontRenderer fontRenderer, String name) {
        minecraft.func_110434_K().func_110577_a(SPEAKING);
        GuiUtil.clearColor();
        AbstractGui.func_238466_a_((MatrixStack)stack, (int)x, (int)y, (int)8, (int)8, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
        RenderOverlayVoiceChat.renderString(fontRenderer, name, 15.0f + (float)x * 1.3333334f, 1.5f + (float)y * 1.3333334f, 0xFFFF00, Matrix4f.func_226593_a_((float)0.75f, (float)0.75f, (float)0.0f), false);
    }

    private static String getName(UUID uuid) {
        NetworkPlayerInfo info;
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null && (info = connection.func_175102_a(uuid)) != null) {
            return info.func_178845_a().getName();
        }
        return uuid.toString();
    }

    private static int renderString(FontRenderer fontRenderer, String text, float x, float y, int color, Matrix4f matrix, boolean dropShadow) {
        if (text == null) {
            return 0;
        }
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        int i = fontRenderer.func_228079_a_(text, x, y, color, dropShadow, matrix, (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        return i;
    }
}

