/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.server;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class PlayerSecretManager {
    private static final BiMap<UUID, Secret> MAP = HashBiMap.create();
    private static final Random RANDOM = new Random();

    public static synchronized void addPlayer(ServerPlayerEntity player) {
        if (MAP.containsKey((Object)player.func_110124_au())) {
            return;
        }
        MAP.put((Object)player.func_110124_au(), (Object)PlayerSecretManager.findFreeSecret());
    }

    public static synchronized void removePlayer(ServerPlayerEntity player) {
        MAP.remove((Object)player.func_110124_au());
    }

    public static ServerPlayerEntity getPlayerBySecret(byte[] secret) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        return server.func_184103_al().func_177451_a((UUID)MAP.inverse().get((Object)new Secret(secret)));
    }

    public static byte[] getSecretByPlayer(ServerPlayerEntity player) {
        return ((Secret)MAP.get((Object)player.func_110124_au())).getSecret();
    }

    private static Secret findFreeSecret() {
        byte[] randomBytes = new byte[8];
        RANDOM.nextBytes(randomBytes);
        Secret secret = new Secret(randomBytes);
        while (MAP.containsValue((Object)secret)) {
            RANDOM.nextBytes(randomBytes);
        }
        return secret;
    }

    public static class Secret {
        private byte[] secret = new byte[8];

        private Secret(byte[] secret) {
            this.secret = secret;
        }

        public byte[] getSecret() {
            return Arrays.copyOf(this.secret, this.secret.length);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.secret);
            return result;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Secret other = (Secret)object;
            return Arrays.equals(this.secret, other.secret);
        }
    }
}

