/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity.util;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.AbstractEntityBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.EntityTypeDefinition;
import dev.itsmeow.betteranimalsplus.imdlib.item.IContainerItem;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;

public class EntityTypeContainerContainable<T extends MobEntity, I extends Item>
extends EntityTypeContainer<T> {
    protected DataParameter<Boolean> fromContainerDataKey;
    protected I containerItem;
    protected Item emptyContainerItem;

    protected EntityTypeContainerContainable(ContainableEntityTypeDefinition<T, I, EntityTypeContainerContainable<T, I>> def) {
        super(def);
        this.containerItem = (Item)def.getContainerSupplier().apply(this, def.getTooltipFunction());
        this.emptyContainerItem = def.getEmptyContainerSupplier().apply(this);
    }

    public DataParameter<Boolean> getFromContainerDataKey() {
        if (this.fromContainerDataKey == null) {
            this.fromContainerDataKey = EntityDataManager.func_187226_a((Class)this.entityClass, (IDataSerializer)DataSerializers.field_187198_h);
        }
        return this.fromContainerDataKey;
    }

    public I getContainerItem() {
        return this.containerItem;
    }

    public Item getEmptyContainerItem() {
        return this.emptyContainerItem;
    }

    public static class Builder<T extends MobEntity, I extends Item>
    extends AbstractEntityBuilderContainable<T, I, EntityTypeContainerContainable<T, I>, Builder<T, I>> {
        protected Builder(Class<T> EntityClass, Function<World, T> func, String entityNameIn, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, String modid) {
            super(EntityClass, func, entityNameIn, attributeMap, modid);
        }

        @Override
        public EntityTypeContainerContainable<T, I> rawBuild() {
            return new EntityTypeContainerContainable(new ContainableEntityTypeDefinition(this));
        }

        @Override
        public Builder<T, I> getImplementation() {
            return this;
        }

        public static <T extends MobEntity, I extends Item> Builder<T, I> create(Class<T> EntityClass, Function<World, T> func, String entityNameIn, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, String modid) {
            return new Builder<T, I>(EntityClass, func, entityNameIn, attributeMap, modid);
        }
    }

    public static abstract class AbstractEntityBuilderContainable<T extends MobEntity, I extends Item, C extends EntityTypeContainerContainable<T, I>, B extends AbstractEntityBuilderContainable<T, I, C, B>>
    extends AbstractEntityBuilder<T, C, B> {
        protected IContainerItem.ITooltipFunction tooltip;
        protected IContainerItem.ITooltipFunction tooltipFinal;
        protected BiFunction<C, IContainerItem.ITooltipFunction, I> containerSupplier;
        protected Function<C, Item> emptyContainerSupplier;

        protected AbstractEntityBuilderContainable(Class<T> EntityClass, Function<World, T> func, String entityNameIn, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, String modid) {
            super(EntityClass, func, entityNameIn, attributeMap, modid);
        }

        public B containers(BiFunction<C, IContainerItem.ITooltipFunction, I> containerSupplier, Function<C, Item> emptyContainerSupplier) {
            return this.containers(containerSupplier, emptyContainerSupplier, null);
        }

        public B containers(BiFunction<C, IContainerItem.ITooltipFunction, I> containerSupplier, Function<C, Item> emptyContainerSupplier, IContainerItem.ITooltipFunction tooltip) {
            this.containerSupplier = containerSupplier;
            this.emptyContainerSupplier = emptyContainerSupplier;
            this.tooltip = tooltip;
            return (B)((AbstractEntityBuilderContainable)this.getImplementation());
        }

        @Override
        public void preBuild() {
            if (this.variantCount > 0) {
                this.tooltipFinal = this.tooltip == null ? IContainerItem.VARIANT_TOOLTIP : (container, stack, worldIn, tooltip) -> {
                    IContainerItem.VARIANT_TOOLTIP.addInformation(container, stack, worldIn, tooltip);
                    this.tooltip.addInformation(container, stack, worldIn, tooltip);
                };
            } else if (this.tooltip != null) {
                this.tooltipFinal = this.tooltip;
            } else if (this.tooltip == null) {
                this.tooltipFinal = (container, stack, world, tooltip) -> {};
            }
        }
    }

    protected static class ContainableEntityTypeDefinition<T extends MobEntity, I extends Item, C extends EntityTypeContainerContainable<T, I>>
    extends EntityTypeDefinition<T> {
        AbstractEntityBuilderContainable<T, I, C, ?> builder;

        public ContainableEntityTypeDefinition(AbstractEntityBuilderContainable<T, I, C, ?> builder) {
            super(builder);
            this.builder = builder;
        }

        public IContainerItem.ITooltipFunction getTooltipFunction() {
            return this.builder.tooltipFinal;
        }

        public BiFunction<C, IContainerItem.ITooltipFunction, I> getContainerSupplier() {
            return this.builder.containerSupplier;
        }

        public Function<C, Item> getEmptyContainerSupplier() {
            return this.builder.emptyContainerSupplier;
        }
    }
}

