/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity.util;

import com.google.common.collect.ImmutableList;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IVariant;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class EntityVariantList {
    private final ArrayList<IVariant> variantList;
    private final HashMap<String, IVariant> nameMap;
    public static final IVariant EMPTY_VARIANT = new EntityVariant("minecraft", "empty", false);

    public EntityVariantList(int size) {
        this.variantList = new ArrayList(size);
        this.nameMap = new HashMap(size);
    }

    @Deprecated
    public IVariant getVariantForIndex(int index) {
        return this.variantList.get(index);
    }

    @Deprecated
    public int getVariantIndex(IVariant variant) {
        return this.variantList.indexOf(variant);
    }

    @Nullable
    @CheckForNull
    public IVariant getVariantForName(String name) {
        return this.nameMap.getOrDefault(name, EMPTY_VARIANT);
    }

    public ImmutableList<IVariant> getVariantList() {
        return ImmutableList.copyOf(this.variantList);
    }

    public void add(IVariant ... variants) {
        for (IVariant variant : variants) {
            this.variantList.add(variant);
            this.nameMap.put(variant.getName(), variant);
        }
    }
}

