/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.item;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IContainable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IContainerItem<T extends MobEntity> {
    public static final ITooltipFunction VARIANT_TOOLTIP = (container, stack, world, tooltip) -> {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("BucketVariantTag", 8)) {
            String id = compoundnbt.func_74779_i("BucketVariantTag");
            TextFormatting[] atextformatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
            tooltip.add(new TranslationTextComponent("entity." + container.getModId() + "." + container.entityName.toLowerCase() + ".type." + container.getVariantForName(id).getName()).func_230530_a_(Style.field_240709_b_.func_240720_a_(atextformatting)));
        }
    };

    public static String getVariantIfPresent(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("BucketVariantTag", 8)) {
            return compoundnbt.func_74779_i("BucketVariantTag");
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    default public <A extends Item> void addPropertyOverrides(A item) {
        ItemModelsProperties.func_239418_a_(item, (ResourceLocation)new ResourceLocation(((IContainerItem)item).getContainer().getModId(), "variant"), (stack, world, entity) -> {
            String variant = IContainerItem.getVariantIfPresent(stack);
            return variant != null && !variant.isEmpty() ? (float)(((IContainerItem)item).getContainer().getVariantIndex(((IContainerItem)item).getContainer().getVariantForName(variant)) + 1) : 0.0f;
        });
    }

    public EntityTypeContainer<T> getContainer();

    default public EntityType<T> getEntityType() {
        return this.getContainer().entityType;
    }

    default public void placeEntity(ServerWorld worldIn, ItemStack stack, BlockPos pos) {
        MobEntity entity = (MobEntity)this.getEntityType().func_220342_a(worldIn, stack.func_77978_p(), stack.func_82837_s() ? stack.func_200301_q() : null, (PlayerEntity)null, pos, SpawnReason.BUCKET, true, false);
        if (entity != null) {
            ((IContainable)entity).setFromContainer(true);
            ((IContainable)entity).readFromContainer(stack);
            if (stack.func_77978_p() != null) {
                ((IContainable)entity).readFromContainerTag(stack.func_77978_p());
            }
        }
    }

    @FunctionalInterface
    public static interface ITooltipFunction {
        public void addInformation(EntityTypeContainerContainable<? extends MobEntity, ?> var1, ItemStack var2, @Nullable World var3, List<ITextComponent> var4);
    }
}

