/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeListBuilder {
    private final Set<RegistryKey<Biome>> extras = new HashSet<RegistryKey<Biome>>();
    private final Set<BiomeDictionary.Type> list = new HashSet<BiomeDictionary.Type>();
    private final Set<BiomeDictionary.Type> blacklist = new HashSet<BiomeDictionary.Type>();
    private final Set<RegistryKey<Biome>> blacklistBiome = new HashSet<RegistryKey<Biome>>();
    private final Set<BiomeDictionary.Type> required = new HashSet<BiomeDictionary.Type>();
    private boolean onlyOverworld = false;

    private BiomeListBuilder() {
    }

    public static BiomeListBuilder create() {
        return new BiomeListBuilder();
    }

    public BiomeListBuilder extra(RegistryKey<Biome> ... extraBiomes) {
        for (RegistryKey<Biome> biome : extraBiomes) {
            this.extras.add(biome);
        }
        return this;
    }

    public BiomeListBuilder extra(BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            this.list.add(type);
        }
        return this;
    }

    public BiomeListBuilder withoutTypes(BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            this.blacklist.add(type);
        }
        return this;
    }

    public BiomeListBuilder withTypes(BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            this.required.add(type);
        }
        return this;
    }

    public BiomeListBuilder withoutBiomes(RegistryKey<Biome> ... biomes) {
        for (RegistryKey<Biome> biome : biomes) {
            this.blacklistBiome.add(biome);
        }
        return this;
    }

    public BiomeListBuilder onlyOverworld() {
        this.onlyOverworld = true;
        return this;
    }

    public RegistryKey<Biome>[] collect() {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(this.extras);
        for (BiomeDictionary.Type extraT : this.list) {
            set.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)extraT));
        }
        if (this.required.size() > 0 || this.blacklist.size() > 0) {
            for (ResourceLocation biomeRL : ForgeRegistries.BIOMES.getKeys()) {
                RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)biomeRL);
                Set types = BiomeDictionary.getTypes((RegistryKey)biomeKey);
                if (types == null) continue;
                boolean pass = true;
                for (BiomeDictionary.Type type : this.required) {
                    if (types.contains(type)) continue;
                    pass = false;
                }
                for (BiomeDictionary.Type type : this.blacklist) {
                    if (!types.contains(type)) continue;
                    pass = false;
                }
                if (this.blacklistBiome.contains(biomeKey)) {
                    pass = false;
                }
                if (this.onlyOverworld && !types.contains(BiomeDictionary.Type.OVERWORLD)) {
                    pass = false;
                }
                if (!pass) continue;
                set.add(biomeKey);
            }
        }
        return set.toArray(new RegistryKey[0]);
    }
}

