/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicates;
import its_meow.betteranimalsplus.common.entity.EntityFeralWolf;
import its_meow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import its_meow.betteranimalsplus.common.entity.ai.HungerNonTamedTargetGoal;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainerBAPTameable;
import its_meow.betteranimalsplus.init.ModEntities;
import java.util.function.Predicate;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityCoyote
extends EntityFeralWolf {
    public static boolean HOSTILE_DAYTIME = false;

    public EntityCoyote(World worldIn) {
        super((EntityType<? extends EntityFeralWolf>)ModEntities.COYOTE.entityType, worldIn);
        this.func_70903_f(false);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, false, e -> e.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<AnimalEntity, EntityCoyote>(this, AnimalEntity.class, false, e -> e instanceof SheepEntity || e instanceof RabbitEntity));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<VillagerEntity, EntityCoyote>(this, VillagerEntity.class, false, (Predicate<LivingEntity>)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<AbstractIllagerEntity, EntityCoyote>(this, AbstractIllagerEntity.class, false, (Predicate<LivingEntity>)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<ChickenEntity, EntityCoyote>(this, ChickenEntity.class, false, (Predicate<LivingEntity>)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(5, new HungerNearestAttackableTargetGoal<AbstractSkeletonEntity, EntityCoyote>(this, AbstractSkeletonEntity.class, false));
    }

    @Override
    public ILivingEntityData initAgeableData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        return livingdata;
    }

    @Override
    public void writeType(CompoundNBT nbt) {
    }

    @Override
    public void readType(CompoundNBT nbt) {
    }

    public boolean isDaytime() {
        long time = this.field_70170_p.func_72820_D() % 24000L;
        return time < 13000L || time > 23000L;
    }

    public void func_70624_b(LivingEntity entitylivingbaseIn) {
        if (!this.isDaytime() || HOSTILE_DAYTIME) {
            super.func_70624_b(entitylivingbaseIn);
        } else if (!this.func_70909_n()) {
            super.func_70624_b(null);
        } else {
            super.func_70624_b(entitylivingbaseIn);
        }
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            super.func_70624_b(null);
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (!(this.isDaytime() && !HOSTILE_DAYTIME || this.func_70909_n())) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(EntityFeralWolf.DATA_HEALTH_ID)).floatValue() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        if (this.func_70638_az() != null) {
            return SoundEvents.field_187861_gG;
        }
        return null;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        Item item;
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            Food food;
            if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_219971_r() && (food = itemstack.func_77973_b().func_219967_s()).func_221467_c() && ((Float)this.field_70180_af.func_187225_a(EntityFeralWolf.DATA_HEALTH_ID)).floatValue() < 20.0f) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(food.func_221466_a());
                return ActionResultType.SUCCESS;
            }
            if (!(!this.func_152114_e((LivingEntity)player) || this.field_70170_p.field_72995_K || this.func_70877_b(itemstack) || itemstack.func_77973_b().func_219971_r() && itemstack.func_77973_b().func_219967_s().func_221467_c())) {
                this.func_233687_w_(!this.func_233684_eK_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (this.isTamingItem(itemstack.func_77973_b())) {
            if (HOSTILE_DAYTIME) {
                if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.betteranimalsplus.coyote.message.always_hostile"), Util.field_240973_b_);
                }
            } else {
                if (this.isDaytime()) {
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.field_70146_Z.nextInt(100) <= 14 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                            this.func_193101_c(player);
                            this.field_70699_by.func_75499_g();
                            this.func_70624_b(null);
                            this.func_233687_w_(true);
                            this.func_70606_j(20.0f);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        } else {
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                    return ActionResultType.SUCCESS;
                }
                if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.betteranimalsplus.coyote.message.currently_hostile"), Util.field_240973_b_);
                }
                return ActionResultType.PASS;
            }
        }
        if (this.func_70877_b(itemstack)) {
            if (this.func_70874_b() == 0 && this.func_213743_em()) {
                this.func_175505_a(player, itemstack);
                this.func_146082_f(player);
                return ActionResultType.CONSUME;
            }
            if (this.func_70631_g_()) {
                this.func_175505_a(player, itemstack);
                this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
                return ActionResultType.CONSUME;
            }
        }
        if ((item = itemstack.func_77973_b()) instanceof SpawnEggItem && ((SpawnEggItem)item).func_208077_a(itemstack.func_77978_p(), this.func_200600_R())) {
            AgeableEntity ageableentity;
            if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld && (ageableentity = this.func_241840_a((ServerWorld)this.field_70170_p, (AgeableEntity)this)) != null) {
                ageableentity.func_70873_a(-24000);
                ageableentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)ageableentity);
                if (itemstack.func_82837_s()) {
                    ageableentity.func_200203_b(itemstack.func_200301_q());
                }
                this.func_213406_a(player, (MobEntity)ageableentity);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public EntityTypeContainerBAPTameable<EntityCoyote> getContainer() {
        return ModEntities.COYOTE;
    }

    @Override
    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity || target instanceof GhastEntity || !this.func_70909_n() && this.isDaytime() && !HOSTILE_DAYTIME)) {
            EntityCoyote entityferalwolf;
            if (target instanceof EntityCoyote && (entityferalwolf = (EntityCoyote)target).func_70909_n() && entityferalwolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            return !(target instanceof AbstractHorseEntity) || !((AbstractHorseEntity)target).func_110248_bS();
        }
        return false;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        EntityCoyote coyote = this.getBaseChild();
        if (this.func_70909_n()) {
            coyote.func_70903_f(true);
            coyote.func_184754_b(this.func_184753_b());
        }
        return coyote;
    }

    @Override
    protected EntityCoyote getBaseChild() {
        return new EntityCoyote(this.field_70170_p);
    }
}

