/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import its_meow.betteranimalsplus.common.entity.util.EntityUtil;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithSelectiveTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModLootTables;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class EntitySongbird
extends EntityAnimalWithSelectiveTypes
implements IFlyingAnimal {
    protected static final DataParameter<Boolean> LANDED = EntityDataManager.func_187226_a(EntitySongbird.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final Set<Item> SEEDS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});

    public EntitySongbird(World worldIn) {
        super((EntityType<? extends EntityAnimalWithSelectiveTypes>)ModEntities.SONGBIRD.entityType, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 180, true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        com.google.common.base.Predicate avoidPredicate = input -> {
            boolean result1 = input instanceof PlayerEntity;
            boolean result2 = !SEEDS.contains(((PlayerEntity)input).func_184586_b(Hand.MAIN_HAND).func_77973_b()) && !SEEDS.contains(((PlayerEntity)input).func_184586_b(Hand.OFF_HAND).func_77973_b());
            return result1 && result2;
        };
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, (Predicate)avoidPredicate, 10.0f, 0.8, 1.0, (Predicate)Predicates.alwaysTrue()));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, (double)0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
        BlockPos blockpos = new BlockPos(i, j, k);
        if (world instanceof World && !((World)world).func_195588_v(new BlockPos((Vector3i)blockpos))) {
            Block block = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c();
            return block instanceof LeavesBlock || block == Blocks.field_150349_c || block.func_203417_a((ITag)BlockTags.field_200031_h) || block == Blocks.field_150350_a && this.field_70170_p.func_201696_r(blockpos) > 8 && super.func_213380_a(world, reason);
        }
        return super.func_213380_a(world, reason);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator pathnavigateflying = new FlyingPathNavigator((MobEntity)this, worldIn);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_212239_d(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LANDED, (Object)true);
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, pos);
        if (this.field_70170_p.func_195588_v(this.func_233580_cy_().func_177977_b())) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b());
            this.field_70180_af.func_187227_b(LANDED, (Object)(this.field_70122_E || this.func_226278_cu_() == Math.floor(this.func_226278_cu_()) && state.func_196952_d((IBlockReader)this.field_70170_p, this.func_233580_cy_().func_177977_b()).func_197758_c(Direction.Axis.Y) == 1.0 && state.func_235785_r_((IBlockReader)this.field_70170_p, this.func_233580_cy_().func_177977_b()) ? 1 : 0));
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return SEEDS.contains(stack.func_77973_b());
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected float func_191954_d(float p_191954_1_) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return p_191954_1_;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(LANDED) == false;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (super.func_70878_b(otherAnimal)) {
            if (!(otherAnimal instanceof EntitySongbird)) {
                return false;
            }
            return !this.getVariantNameOrEmpty().isEmpty() && !((EntitySongbird)otherAnimal).getVariantNameOrEmpty().isEmpty() && ((EntitySongbird)otherAnimal).getVariantNameOrEmpty().equals(this.getVariantNameOrEmpty());
        }
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.songbird;
    }

    @Override
    protected EntitySongbird getBaseChild() {
        return new EntitySongbird(this.field_70170_p);
    }

    @Override
    public String[] getTypesFor(RegistryKey<Biome> biomeKey, Biome biome, Set<BiomeDictionary.Type> types, SpawnReason reason) {
        if (types.contains(BiomeDictionary.Type.FOREST) && !types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            return new String[]{"2", "small_2", "small_3", "small_4"};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && !types.contains(BiomeDictionary.Type.SNOWY)) {
            return new String[]{"1", "small_5", "small_6"};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && types.contains(BiomeDictionary.Type.SNOWY)) {
            return new String[]{"3", "4", "small_1"};
        }
        return new String[]{"1", "2", "3", "4", "small_1", "small_2", "small_3", "small_4", "small_5", "small_6"};
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingdata, CompoundNBT compound) {
        return EntityUtil.childChance((AgeableEntity)this, reason, super.func_213386_a(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    @Override
    public EntityTypeContainer<EntitySongbird> getContainer() {
        return ModEntities.SONGBIRD;
    }

    public static boolean canSongbirdSpawn(EntityType<EntitySongbird> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return MobEntity.func_223315_a(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand) || below.func_203417_a((ITag)BlockTags.field_206952_E) || below.func_203417_a((ITag)BlockTags.field_200031_h);
    }
}

