/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IContainerEntity;
import its_meow.betteranimalsplus.common.entity.ai.HybridPathNavigator;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModLootTables;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityWalrus
extends AnimalEntity
implements IContainerEntity<EntityWalrus> {
    private static final DataParameter<BlockPos> HOME_POS = EntityDataManager.func_187226_a(EntityWalrus.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<BlockPos> TRAVEL_POS = EntityDataManager.func_187226_a(EntityWalrus.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> GOING_HOME = EntityDataManager.func_187226_a(EntityWalrus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TRAVELLING = EntityDataManager.func_187226_a(EntityWalrus.class, (IDataSerializer)DataSerializers.field_187198_h);
    public boolean hasGivenDisc = false;

    public EntityWalrus(World worldIn) {
        super(ModEntities.WALRUS.entityType, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 1.0f;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.hasGivenDisc && stack.func_77973_b() == ModItems.FRIED_EGG.get()) {
            this.func_175505_a(player, stack);
            this.field_70170_p.func_72960_a((Entity)this, (byte)90);
            this.hasGivenDisc = true;
            this.func_199701_a_(new ItemStack((IItemProvider)ModItems.RECORD_WALRUS.get()));
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 90) {
            for (int i = 0; i < 7; ++i) {
                double x = this.field_70146_Z.nextGaussian() * 0.02;
                double y = this.field_70146_Z.nextGaussian() * 0.02;
                double z = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), x, y, z);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(this.func_70681_au().nextInt(3) == 0 ? DamageSource.func_76358_a((LivingEntity)this).func_76348_h() : DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        if (flag) {
            Vector3d pos = this.func_213303_ch();
            Vector3d targetPos = entityIn.func_213303_ch();
            ((LivingEntity)entityIn).func_233627_a_(0.5f, pos.field_72450_a - targetPos.field_72450_a, pos.field_72449_c - targetPos.field_72449_c);
        }
        return flag;
    }

    public void setHome(BlockPos position) {
        this.field_70180_af.func_187227_b(HOME_POS, (Object)position);
    }

    private BlockPos getHome() {
        return (BlockPos)this.field_70180_af.func_187225_a(HOME_POS);
    }

    private void setTravelPos(BlockPos position) {
        this.field_70180_af.func_187227_b(TRAVEL_POS, (Object)position);
    }

    private BlockPos getTravelPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(TRAVEL_POS);
    }

    private boolean isGoingHome() {
        return (Boolean)this.field_70180_af.func_187225_a(GOING_HOME);
    }

    private void setGoingHome(boolean isGoingHome) {
        this.field_70180_af.func_187227_b(GOING_HOME, (Object)isGoingHome);
    }

    private boolean isTravelling() {
        return (Boolean)this.field_70180_af.func_187225_a(TRAVELLING);
    }

    private void setTravelling(boolean isTravelling) {
        this.field_70180_af.func_187227_b(TRAVELLING, (Object)isTravelling);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HOME_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(TRAVEL_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(GOING_HOME, (Object)false);
        this.field_70180_af.func_187214_a(TRAVELLING, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("HomePosX", this.getHome().func_177958_n());
        compound.func_74768_a("HomePosY", this.getHome().func_177956_o());
        compound.func_74768_a("HomePosZ", this.getHome().func_177952_p());
        compound.func_74768_a("TravelPosX", this.getTravelPos().func_177958_n());
        compound.func_74768_a("TravelPosY", this.getTravelPos().func_177956_o());
        compound.func_74768_a("TravelPosZ", this.getTravelPos().func_177952_p());
        compound.func_74757_a("DiscGiven", this.hasGivenDisc);
    }

    public void func_70037_a(CompoundNBT compound) {
        int i = compound.func_74762_e("HomePosX");
        int j = compound.func_74762_e("HomePosY");
        int k = compound.func_74762_e("HomePosZ");
        this.setHome(new BlockPos(i, j, k));
        super.func_70037_a(compound);
        int l = compound.func_74762_e("TravelPosX");
        int i1 = compound.func_74762_e("TravelPosY");
        int j1 = compound.func_74762_e("TravelPosZ");
        this.setTravelPos(new BlockPos(l, i1, j1));
        this.hasGivenDisc = compound.func_74767_n("DiscGiven");
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setHome(this.func_233580_cy_());
        this.setTravelPos(BlockPos.field_177992_a);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean canSpawn(EntityType<EntityWalrus> walrus, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return pos.func_177956_o() < world.func_181545_F() + 4 && world.func_226659_b_(pos, 0) > 8;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new GoHomeGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TravelGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false){

            protected double func_179512_a(LivingEntity attackTarget) {
                return this.field_75441_b.func_213311_cf() * this.field_75441_b.func_213311_cf() + attackTarget.func_213311_cf();
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WanderGoal(this, 1.0, 100));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){

            public boolean func_75250_a() {
                return EntityWalrus.this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && super.func_75250_a();
            }
        });
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70648_aU() {
        return false;
    }

    protected void updateAir(int p_209207_1_) {
    }

    public int func_205010_bg() {
        return 6000;
    }

    protected int func_207300_l(int currentAir) {
        return this.func_205010_bg();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 0.6f);
    }

    protected float func_203009_ad() {
        return this.field_82151_R + 0.15f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new HybridPathNavigator<EntityWalrus>(this, worldIn, EntityWalrus::isTravelling);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (!this.isGoingHome() && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            return 10.0f;
        }
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a((ITag)BlockTags.field_205213_E) ? 10.0f : worldIn.func_205052_D(pos) - 0.5f;
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (!(this.func_70638_az() != null || this.isGoingHome() && this.getHome().func_218137_a((IPosition)this.func_213303_ch(), 20.0))) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.WALRUS;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return null;
    }

    public boolean func_213397_c(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityWalrus getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<?> getContainer() {
        return ModEntities.WALRUS;
    }

    public static class WanderGoal
    extends RandomWalkingGoal {
        private final EntityWalrus walrus;

        public WanderGoal(EntityWalrus walrus, double speed, int chance) {
            super((CreatureEntity)walrus, speed, chance);
            this.walrus = walrus;
        }

        public boolean func_75250_a() {
            return !this.field_75457_a.func_70090_H() && !this.walrus.isGoingHome() && super.func_75250_a();
        }
    }

    public static class TravelGoal
    extends Goal {
        private final EntityWalrus walrus;
        private final double speed;
        private boolean noPosition;

        public TravelGoal(EntityWalrus walrus, double speed) {
            this.walrus = walrus;
            this.speed = speed;
        }

        public boolean func_75250_a() {
            return !this.walrus.isGoingHome() && this.walrus.func_70090_H();
        }

        public void func_75249_e() {
            int xzRange = 512;
            int yRange = 4;
            Random random = this.walrus.field_70146_Z;
            int xOff = random.nextInt(xzRange * 2 + 1) - xzRange;
            int yOff = random.nextInt(yRange * 2 + 1) - yRange;
            int zOff = random.nextInt(xzRange * 2 + 1) - xzRange;
            if ((double)yOff + this.walrus.func_226278_cu_() > (double)(this.walrus.field_70170_p.func_181545_F() - 1)) {
                yOff = 0;
            }
            BlockPos blockpos = new BlockPos((double)xOff + this.walrus.func_226277_ct_(), (double)yOff + this.walrus.func_226278_cu_(), (double)zOff + this.walrus.func_226281_cx_());
            this.walrus.setTravelPos(blockpos);
            this.walrus.setTravelling(true);
            this.noPosition = false;
        }

        public void func_75246_d() {
            if (this.walrus.func_70661_as().func_75500_f()) {
                int z;
                int range;
                int x;
                BlockPos blockpos = this.walrus.getTravelPos();
                Vector3d dest = RandomPositionGenerator.func_203155_a((CreatureEntity)this.walrus, (int)16, (int)3, (Vector3d)new Vector3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()), (double)0.3141592653589793);
                if (dest == null) {
                    dest = RandomPositionGenerator.func_75464_a((CreatureEntity)this.walrus, (int)8, (int)7, (Vector3d)new Vector3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()));
                }
                if (dest != null && !this.walrus.field_70170_p.func_217344_a((x = MathHelper.func_76128_c((double)dest.field_72450_a)) - (range = 34), 0, (z = MathHelper.func_76128_c((double)dest.field_72449_c)) - range, x + range, 0, z + range)) {
                    dest = null;
                }
                if (dest == null) {
                    this.noPosition = true;
                    return;
                }
                this.walrus.func_70661_as().func_75492_a(dest.field_72450_a, dest.field_72448_b, dest.field_72449_c, this.speed);
            }
        }

        public boolean func_75253_b() {
            return !this.walrus.func_70661_as().func_75500_f() && !this.noPosition && !this.walrus.isGoingHome();
        }

        public void func_75251_c() {
            this.walrus.setTravelling(false);
            super.func_75251_c();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityWalrus walrus;

        MoveHelperController(EntityWalrus walrus) {
            super((MobEntity)walrus);
            this.walrus = walrus;
        }

        private void updateSpeed() {
            if (this.walrus.func_70090_H()) {
                this.walrus.func_213317_d(this.walrus.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
                if (!this.walrus.getHome().func_218137_a((IPosition)this.walrus.func_213303_ch(), 16.0)) {
                    this.walrus.func_70659_e(Math.max(this.walrus.func_70689_ay() / 2.0f, 0.2f));
                }
            } else if (this.walrus.field_70122_E) {
                this.walrus.func_70659_e(Math.max(this.walrus.func_70689_ay() / 2.0f, 0.06f));
            }
        }

        public void func_75641_c() {
            this.updateSpeed();
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.walrus.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.walrus.func_226277_ct_();
                double d1 = this.field_75647_c - this.walrus.func_226278_cu_();
                double d2 = this.field_75644_d - this.walrus.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.walrus.field_70761_aq = this.walrus.field_70177_z = this.func_75639_a(this.walrus.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.walrus.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                this.walrus.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.walrus.func_70689_ay(), (float)f1));
                this.walrus.func_213317_d(this.walrus.func_213322_ci().func_72441_c(0.0, (double)this.walrus.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.walrus.func_70659_e(0.0f);
            }
        }
    }

    public static class GoToWaterGoal
    extends MoveToBlockGoal {
        private final EntityWalrus walrus;

        public GoToWaterGoal(EntityWalrus walrus, double speed) {
            super((CreatureEntity)walrus, speed, 24);
            this.walrus = walrus;
            this.field_203112_e = -1;
        }

        public boolean func_75253_b() {
            return !this.walrus.func_70090_H() && this.field_179493_e <= 1200 && this.func_179488_a((IWorldReader)this.walrus.field_70170_p, this.field_179494_b);
        }

        public boolean func_75250_a() {
            if (this.walrus.func_70631_g_() && !this.walrus.func_70090_H()) {
                return super.func_75250_a();
            }
            return !this.walrus.isGoingHome() && !this.walrus.func_70090_H() && super.func_75250_a();
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 160 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_150355_j;
        }
    }

    public static class GoHomeGoal
    extends Goal {
        private final EntityWalrus walrus;
        private final double speed;
        private boolean noPosition;
        private int ticksRan;

        public GoHomeGoal(EntityWalrus walrus, double speedIn) {
            this.walrus = walrus;
            this.speed = speedIn;
        }

        public boolean func_75250_a() {
            if (this.walrus.func_70631_g_()) {
                return false;
            }
            if (this.walrus.func_70681_au().nextInt(700) != 0) {
                return false;
            }
            return !this.walrus.getHome().func_218137_a((IPosition)this.walrus.func_213303_ch(), 64.0);
        }

        public void func_75249_e() {
            this.walrus.setGoingHome(true);
            this.noPosition = false;
            this.ticksRan = 0;
        }

        public void func_75251_c() {
            this.walrus.setGoingHome(false);
        }

        public boolean func_75253_b() {
            return !this.walrus.getHome().func_218137_a((IPosition)this.walrus.func_213303_ch(), 7.0) && !this.noPosition && this.ticksRan <= 600;
        }

        public void func_75246_d() {
            BlockPos blockpos = this.walrus.getHome();
            boolean nearHome = blockpos.func_218137_a((IPosition)this.walrus.func_213303_ch(), 16.0);
            if (nearHome) {
                ++this.ticksRan;
            }
            if (this.walrus.func_70661_as().func_75500_f()) {
                Vector3d vec3d = RandomPositionGenerator.func_203155_a((CreatureEntity)this.walrus, (int)16, (int)3, (Vector3d)new Vector3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()), (double)0.3141592741012573);
                if (vec3d == null) {
                    vec3d = RandomPositionGenerator.func_75464_a((CreatureEntity)this.walrus, (int)8, (int)7, (Vector3d)new Vector3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()));
                }
                if (vec3d != null && !nearHome && this.walrus.field_70170_p.func_180495_p(new BlockPos(vec3d)).func_177230_c() != Blocks.field_150355_j) {
                    vec3d = RandomPositionGenerator.func_75464_a((CreatureEntity)this.walrus, (int)16, (int)5, (Vector3d)new Vector3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()));
                }
                if (vec3d == null) {
                    this.noPosition = true;
                    return;
                }
                this.walrus.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.speed);
            }
        }
    }
}

