/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity.ai;

import java.util.EnumSet;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;

public abstract class MoveIntoBlockGoal
extends Goal {
    protected final CreatureEntity creature;
    public final double movementSpeed;
    protected int runDelay;
    protected int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.field_177992_a;
    private boolean isAtDestination;
    private final int searchLength;
    private final int field_203113_j;
    protected int field_203112_e;

    public MoveIntoBlockGoal(CreatureEntity creature, double speedIn, int length) {
        this(creature, speedIn, length, 1);
    }

    public MoveIntoBlockGoal(CreatureEntity creatureIn, double speed, int length, int p_i48796_5_) {
        this.creature = creatureIn;
        this.movementSpeed = speed;
        this.searchLength = length;
        this.field_203112_e = 0;
        this.field_203113_j = p_i48796_5_;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = this.getRunDelay(this.creature);
        return this.searchForDestination();
    }

    protected int getRunDelay(CreatureEntity creatureIn) {
        return 200 + creatureIn.func_70681_au().nextInt(200);
    }

    public boolean func_75253_b() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo((IWorldReader)this.creature.field_70170_p, this.destinationBlock);
    }

    public void func_75249_e() {
        this.func_220725_g();
        this.timeoutCounter = 0;
        this.maxStayTicks = this.creature.func_70681_au().nextInt(this.creature.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    protected void func_220725_g() {
        this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
    }

    public double getTargetDistanceSq() {
        return 1.0;
    }

    public void func_75246_d() {
        if (!this.destinationBlock.func_218137_a((IPosition)this.creature.func_213303_ch(), this.getTargetDistanceSq())) {
            this.isAtDestination = false;
            ++this.timeoutCounter;
            if (this.shouldMove()) {
                this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
            }
        } else {
            this.isAtDestination = true;
            --this.timeoutCounter;
        }
    }

    public boolean shouldMove() {
        return this.timeoutCounter % 40 == 0;
    }

    protected boolean isAtDestination() {
        return this.isAtDestination;
    }

    protected boolean searchForDestination() {
        int i = this.searchLength;
        int j = this.field_203113_j;
        BlockPos blockpos = this.creature.func_233580_cy_();
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
        int k = this.field_203112_e;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        blockpos$mutableblockpos.func_189533_g((Vector3i)blockpos).func_196234_d(i1, k - 1, j1);
                        if (this.creature.func_213389_a((BlockPos)blockpos$mutableblockpos) && this.shouldMoveTo((IWorldReader)this.creature.field_70170_p, (BlockPos)blockpos$mutableblockpos)) {
                            this.destinationBlock = blockpos$mutableblockpos;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    protected abstract boolean shouldMoveTo(IWorldReader var1, BlockPos var2);
}

