/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity.util;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.AbstractEntityBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.EntityTypeDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class EntityTypeContainerBAPTameable<T extends TameableEntity>
extends EntityTypeContainer<T> {
    protected String[] tameItemsStore;
    protected ForgeConfigSpec.ConfigValue<List<? extends String>> tameItems;
    protected String[] defaultTameItems;

    private EntityTypeContainerBAPTameable(TameableEntityTypeDefinition<T> def) {
        super(def);
        this.defaultTameItems = def.getTameItems();
    }

    public String[] getTameItems() {
        return this.tameItemsStore;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setTameItems(String[] items) {
        this.tameItemsStore = items;
    }

    @Override
    public void configurationLoad() {
        super.configurationLoad();
        this.tameItemsStore = ((List)this.tameItems.get()).toArray(new String[0]);
    }

    @Override
    public void customConfigurationInit(ForgeConfigSpec.Builder builder) {
        super.customConfigurationInit(builder);
        this.tameItems = builder.comment("List of acceptable item IDs to use for taming. Accepts tags by prefixing them with '#'.").worldRestart().defineList("tameItems", Arrays.asList(this.defaultTameItems), input -> input instanceof String);
    }

    public static class Builder<T extends TameableEntity>
    extends AbstractEntityBuilderBAPTameable<T, EntityTypeContainerBAPTameable<T>, Builder<T>> {
        protected Builder(Class<T> EntityClass, Function<World, T> func, String entityNameIn, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, String modid) {
            super(EntityClass, func, entityNameIn, attributeMap, modid);
        }

        @Override
        public EntityTypeContainerBAPTameable<T> rawBuild() {
            return new EntityTypeContainerBAPTameable(new TameableEntityTypeDefinition(this));
        }

        @Override
        public Builder<T> getImplementation() {
            return this;
        }

        public static <T extends TameableEntity> Builder<T> create(Class<T> EntityClass, Function<World, T> func, String entityNameIn, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, String modid) {
            return new Builder<T>(EntityClass, func, entityNameIn, attributeMap, modid);
        }
    }

    public static abstract class AbstractEntityBuilderBAPTameable<T extends TameableEntity, C extends EntityTypeContainerBAPTameable<T>, B extends AbstractEntityBuilderBAPTameable<T, C, B>>
    extends AbstractEntityBuilder<T, C, B> {
        protected String[] defaultTameItems;

        protected AbstractEntityBuilderBAPTameable(Class<T> EntityClass, Function<World, T> func, String entityNameIn, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, String modid) {
            super(EntityClass, func, entityNameIn, attributeMap, modid);
        }

        public B tameItems(String ... items) {
            this.defaultTameItems = items;
            return (B)((AbstractEntityBuilderBAPTameable)this.getImplementation());
        }
    }

    protected static class TameableEntityTypeDefinition<T extends TameableEntity>
    extends EntityTypeDefinition<T> {
        AbstractEntityBuilderBAPTameable<T, ?, ?> builder;

        public TameableEntityTypeDefinition(AbstractEntityBuilderBAPTameable<T, ?, ?> builder) {
            super(builder);
            this.builder = builder;
        }

        public String[] getTameItems() {
            return this.builder.defaultTameItems;
        }
    }
}

