/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity.util.abstracts;

import its_meow.betteranimalsplus.common.entity.ai.PeacefulNearestAttackableTargetGoal;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathingWithTypesBucketable;
import its_meow.betteranimalsplus.init.ModLootTables;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityEelBase
extends EntityWaterMobPathingWithTypesBucketable {
    private static final Predicate<ItemEntity> ITEM_SELECTOR = item -> !item.func_174874_s() && item.func_70089_S() && item.func_92059_d().func_222117_E();
    private int collideWithItemTicks = 0;
    private ItemEntity collidedItem = null;

    public EntityEelBase(EntityType<? extends EntityEelBase> entityType, World worldIn) {
        super((EntityType<? extends EntityWaterMobPathingWithTypesBucketable>)entityType, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.8, false){

            public boolean func_75253_b() {
                if (EntityEelBase.this.shouldCheckTarget() && EntityEelBase.this.func_70638_az() != null && !EntityEelBase.isHoldingFood(EntityEelBase.this.func_70638_az())) {
                    EntityEelBase.this.func_70624_b(null);
                    return false;
                }
                return super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveToFoodItemsGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 0.25, 1));
        this.field_70715_bh.func_75776_a(1, new PeacefulNearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, 0, true, true, EntityEelBase::isHoldingFood));
    }

    protected boolean shouldCheckTarget() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        List items = this.field_70170_p.func_175647_a(ItemEntity.class, this.func_174813_aQ().func_186662_g(0.4), ITEM_SELECTOR);
        if (items.size() > 0 && (this.collidedItem == null || items.contains(this.collidedItem))) {
            if (this.collidedItem == null) {
                this.collidedItem = (ItemEntity)items.get(this.func_70681_au().nextInt(items.size()));
            }
            ++this.collideWithItemTicks;
            if (this.collideWithItemTicks > 35) {
                if (this.func_70681_au().nextFloat() < 0.1f) {
                    this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                }
                if (this.collideWithItemTicks > 40 && this.func_70681_au().nextInt(20) == 0) {
                    this.collideWithItemTicks = 0;
                    ItemEntity item = this.collidedItem;
                    ItemStack stack = item.func_92059_d();
                    if (stack.func_222117_E()) {
                        this.func_70691_i(stack.func_77973_b().func_219967_s().func_221469_b());
                        item.func_70106_y();
                        this.collidedItem = null;
                        this.collideWithItemTicks = 0;
                    }
                }
            }
        } else {
            this.collideWithItemTicks = 0;
            this.collidedItem = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack stack;
            if (this.collidedItem != null && !(stack = this.collidedItem.func_92059_d()).func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vector3d vec3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
    }

    protected static boolean isHoldingFood(LivingEntity entity) {
        return entity.func_184614_ca().func_222117_E() || entity.func_184592_cb().func_222117_E();
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.EELY;
    }

    public class MoveToFoodItemsGoal
    extends Goal {
        public MoveToFoodItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (EntityEelBase.this.func_70638_az() == null && EntityEelBase.this.func_70643_av() == null) {
                if (EntityEelBase.this.func_70681_au().nextInt(2) != 0) {
                    return false;
                }
                List list = EntityEelBase.this.field_70170_p.func_175647_a(ItemEntity.class, EntityEelBase.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
                return !list.isEmpty();
            }
            return false;
        }

        public void func_75246_d() {
            List list = EntityEelBase.this.field_70170_p.func_175647_a(ItemEntity.class, EntityEelBase.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityEelBase.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List list = EntityEelBase.this.field_70170_p.func_175647_a(ItemEntity.class, EntityEelBase.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityEelBase.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

