/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeDictionary;

public class OceanBiomeHelper {
    public static boolean isColdOrFrozenOcean(RegistryKey<Biome> biome) {
        Set types = BiomeDictionary.getTypes(biome);
        return types.contains(BiomeDictionary.Type.OCEAN) && (biome == Biomes.field_203616_V || biome == Biomes.field_203619_Y || biome == Biomes.field_203620_Z || biome == Biomes.field_76776_l || types.contains(BiomeDictionary.Type.COLD) && types.contains(BiomeDictionary.Type.OCEAN));
    }

    public static boolean isDeepOcean(RegistryKey<Biome> biome) {
        Set types = BiomeDictionary.getTypes(biome);
        return types.contains(BiomeDictionary.Type.OCEAN) && (biome == Biomes.field_203620_Z || biome == Biomes.field_203619_Y || biome == Biomes.field_203618_X || biome == Biomes.field_150575_M || biome == Biomes.field_203617_W || biome.getRegistryName().func_110623_a().contains("deep"));
    }

    public static boolean isFrozenOcean(RegistryKey<Biome> biome) {
        Set types = BiomeDictionary.getTypes(biome);
        return types.contains(BiomeDictionary.Type.OCEAN) && (biome == Biomes.field_203620_Z || biome == Biomes.field_76776_l || biome.getRegistryName().func_110623_a().contains("frozen"));
    }

    public static boolean isWarmOcean(RegistryKey<Biome> biome) {
        Set types = BiomeDictionary.getTypes(biome);
        return types.contains(BiomeDictionary.Type.OCEAN) && (biome == Biomes.field_203617_W || biome == Biomes.field_203614_T || biome.getRegistryName().func_110623_a().contains("warm") && !biome.getRegistryName().func_110623_a().contains("lukewarm"));
    }

    public static boolean isLukewarmOcean(RegistryKey<Biome> biome) {
        Set types = BiomeDictionary.getTypes(biome);
        return types.contains(BiomeDictionary.Type.OCEAN) && (biome == Biomes.field_203618_X || biome == Biomes.field_203615_U || biome.getRegistryName().func_110623_a().contains("lukewarm"));
    }

    public static RegistryKey<Biome>[] subtropicalOcean() {
        return OceanBiomeHelper.removeIf(biome -> !OceanBiomeHelper.isWarmOcean((RegistryKey<Biome>)biome) && !OceanBiomeHelper.isLukewarmOcean((RegistryKey<Biome>)biome) || OceanBiomeHelper.isDeepOcean((RegistryKey<Biome>)biome));
    }

    public static RegistryKey<Biome>[] returnIf(Predicate<RegistryKey<Biome>> filter) {
        HashSet<RegistryKey> oceans = new HashSet<RegistryKey>();
        for (RegistryKey b : BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            if (!filter.test((RegistryKey<Biome>)b)) continue;
            oceans.add(b);
        }
        return oceans.toArray(new RegistryKey[0]);
    }

    public static RegistryKey<Biome>[] removeIf(Predicate<RegistryKey<Biome>> filter) {
        HashSet<RegistryKey<Biome>> oceans = new HashSet<RegistryKey<Biome>>(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        oceans.removeIf(filter);
        return oceans.toArray(new RegistryKey[0]);
    }

    public static class Wrapper {
        private final boolean coldOrFrozen;
        private final boolean deep;
        private final boolean frozen;
        private final boolean warm;
        private final boolean lukewarm;

        public Wrapper(RegistryKey<Biome> biome) {
            this.coldOrFrozen = OceanBiomeHelper.isColdOrFrozenOcean(biome);
            this.deep = OceanBiomeHelper.isDeepOcean(biome);
            this.frozen = OceanBiomeHelper.isFrozenOcean(biome);
            this.warm = OceanBiomeHelper.isWarmOcean(biome);
            this.lukewarm = OceanBiomeHelper.isLukewarmOcean(biome);
        }

        public boolean isLukewarm() {
            return this.lukewarm;
        }

        public boolean isWarm() {
            return this.warm;
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public boolean isDeep() {
            return this.deep;
        }

        public boolean isColdOrFrozen() {
            return this.coldOrFrozen;
        }
    }
}

