/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IJEIConfig;
import mezz.jei.config.IngredientFilterConfigValues;
import mezz.jei.config.SearchMode;
import net.minecraftforge.common.ForgeConfigSpec;

public class IngredientFilterConfig
implements IIngredientFilterConfig,
IJEIConfig {
    private final IngredientFilterConfigValues values = new IngredientFilterConfigValues();
    public final ForgeConfigSpec.EnumValue<SearchMode> modNameSearchMode;
    public final ForgeConfigSpec.EnumValue<SearchMode> tooltipSearchMode;
    public final ForgeConfigSpec.EnumValue<SearchMode> tagSearchMode;
    public final ForgeConfigSpec.EnumValue<SearchMode> creativeTabSearchMode;
    public final ForgeConfigSpec.EnumValue<SearchMode> colorSearchMode;
    public final ForgeConfigSpec.EnumValue<SearchMode> resourceIdSearchMode;
    public final ForgeConfigSpec.BooleanValue searchAdvancedTooltips;

    public IngredientFilterConfig(ForgeConfigSpec.Builder builder) {
        IngredientFilterConfigValues defaultValues = new IngredientFilterConfigValues();
        builder.push("search");
        builder.comment("Search mode for Mod Names (prefix: @)");
        this.modNameSearchMode = builder.defineEnum("ModNameSearchMode", (Enum)defaultValues.modNameSearchMode);
        builder.comment("Search mode for Tooltips (prefix: #)");
        this.tooltipSearchMode = builder.defineEnum("TooltipSearchMode", (Enum)defaultValues.tooltipSearchMode);
        builder.comment("Search mode for Tag Names (prefix: $)");
        this.tagSearchMode = builder.defineEnum("TagSearchMode", (Enum)defaultValues.tagSearchMode);
        builder.comment("Search mode for Creative Tab Names (prefix: %)");
        this.creativeTabSearchMode = builder.defineEnum("CreativeTabSearchMode", (Enum)defaultValues.creativeTabSearchMode);
        builder.comment("Search mode for Colors (prefix: ^)");
        this.colorSearchMode = builder.defineEnum("ColorSearchMode", (Enum)defaultValues.colorSearchMode);
        builder.comment("Search mode for resources IDs (prefix: &)");
        this.resourceIdSearchMode = builder.defineEnum("ResourceIdSearchMode", (Enum)defaultValues.resourceIdSearchMode);
        builder.comment("Search advanced tooltips (visible with F3+H)");
        this.searchAdvancedTooltips = builder.define("SearchAdvancedTooltips", defaultValues.searchAdvancedTooltips);
        builder.pop();
    }

    @Override
    public void buildSettingsGUI(ConfigGroup group) {
        IngredientFilterConfigValues defaultValues = new IngredientFilterConfigValues();
        group.addEnum(this.cfgTranslation("modNameSearchMode"), (Object)this.values.modNameSearchMode, v -> {
            this.modNameSearchMode.set((Object)v);
            this.values.modNameSearchMode = v;
        }, NameMap.of((Object)((Object)defaultValues.modNameSearchMode), (Object[])SearchMode.values()).create());
        group.addEnum(this.cfgTranslation("tooltipSearchMode"), (Object)this.values.tooltipSearchMode, v -> {
            this.tooltipSearchMode.set((Object)v);
            this.values.tooltipSearchMode = v;
        }, NameMap.of((Object)((Object)defaultValues.tooltipSearchMode), (Object[])SearchMode.values()).create());
        group.addEnum(this.cfgTranslation("tagSearchMode"), (Object)this.values.tagSearchMode, v -> {
            this.tagSearchMode.set((Object)v);
            this.values.tagSearchMode = v;
        }, NameMap.of((Object)((Object)defaultValues.tagSearchMode), (Object[])SearchMode.values()).create());
        group.addEnum(this.cfgTranslation("creativeTabSearchMode"), (Object)this.values.creativeTabSearchMode, v -> {
            this.creativeTabSearchMode.set((Object)v);
            this.values.creativeTabSearchMode = v;
        }, NameMap.of((Object)((Object)defaultValues.creativeTabSearchMode), (Object[])SearchMode.values()).create());
        group.addEnum(this.cfgTranslation("colorSearchMode"), (Object)this.values.colorSearchMode, v -> {
            this.colorSearchMode.set((Object)v);
            this.values.colorSearchMode = v;
        }, NameMap.of((Object)((Object)defaultValues.colorSearchMode), (Object[])SearchMode.values()).create());
        group.addEnum(this.cfgTranslation("resourceIdSearchMode"), (Object)this.values.resourceIdSearchMode, v -> {
            this.resourceIdSearchMode.set((Object)v);
            this.values.resourceIdSearchMode = v;
        }, NameMap.of((Object)((Object)defaultValues.resourceIdSearchMode), (Object[])SearchMode.values()).create());
        group.addBool(this.cfgTranslation("searchAdvancedTooltips"), this.values.searchAdvancedTooltips, v -> {
            this.searchAdvancedTooltips.set(v);
            this.values.searchAdvancedTooltips = v;
        }, defaultValues.searchAdvancedTooltips);
    }

    private String cfgTranslation(String name) {
        return "search." + name;
    }

    @Override
    public void reload() {
        this.values.modNameSearchMode = (SearchMode)((Object)this.modNameSearchMode.get());
        this.values.tooltipSearchMode = (SearchMode)((Object)this.tooltipSearchMode.get());
        this.values.tagSearchMode = (SearchMode)((Object)this.tagSearchMode.get());
        this.values.creativeTabSearchMode = (SearchMode)((Object)this.creativeTabSearchMode.get());
        this.values.colorSearchMode = (SearchMode)((Object)this.colorSearchMode.get());
        this.values.resourceIdSearchMode = (SearchMode)((Object)this.resourceIdSearchMode.get());
        this.values.searchAdvancedTooltips = (Boolean)this.searchAdvancedTooltips.get();
    }

    @Override
    public SearchMode getModNameSearchMode() {
        return this.values.modNameSearchMode;
    }

    @Override
    public SearchMode getTooltipSearchMode() {
        return this.values.tooltipSearchMode;
    }

    @Override
    public SearchMode getTagSearchMode() {
        return this.values.tagSearchMode;
    }

    @Override
    public SearchMode getCreativeTabSearchMode() {
        return this.values.creativeTabSearchMode;
    }

    @Override
    public SearchMode getColorSearchMode() {
        return this.values.colorSearchMode;
    }

    @Override
    public SearchMode getResourceIdSearchMode() {
        return this.values.resourceIdSearchMode;
    }

    @Override
    public boolean getSearchAdvancedTooltips() {
        return this.values.searchAdvancedTooltips;
    }
}

