/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.corelib;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CachedMap<K, V> {
    private final Map<K, ValueWrapper> cache;
    private final long lifespan;
    private long lastCheck;

    protected CachedMap(Map<K, ValueWrapper> map, long lifespan) {
        this.lifespan = lifespan;
        this.cache = map;
    }

    public CachedMap(long lifespan, Comparator<K> comparator) {
        this(new TreeMap(comparator), lifespan);
    }

    public CachedMap(long lifespan) {
        this(new HashMap(), lifespan);
    }

    public CachedMap() {
        this(-1L);
    }

    public V get(K key, Supplier<V> valueSupplier) {
        V value;
        if (this.cache.containsKey(key)) {
            value = this.cache.get(key).getValue();
        } else {
            value = valueSupplier.get();
            this.cache.put(key, new ValueWrapper(value));
        }
        this.cleanup();
        return value;
    }

    private void cleanup() {
        long time = System.currentTimeMillis();
        if (this.lifespan > 0L && time - this.lastCheck > this.lifespan) {
            Collection collect = this.cache.entrySet().stream().filter(kValueWrapperEntry -> ((ValueWrapper)kValueWrapperEntry.getValue()).checkInvalid(time)).map(Map.Entry::getKey).collect(Collectors.toSet());
            this.cache.keySet().removeAll(collect);
            this.lastCheck = time;
        }
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    private class ValueWrapper {
        private V value;
        private long accessTimestamp;

        public ValueWrapper(V value) {
            this.value = value;
            this.accessTimestamp = System.currentTimeMillis();
        }

        public boolean checkInvalid(long currentTime) {
            return currentTime - this.accessTimestamp > CachedMap.this.lifespan;
        }

        public V getValue() {
            this.accessTimestamp = System.currentTimeMillis();
            return this.value;
        }
    }
}

