/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.corelib.item;

import java.util.Comparator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

public class ItemUtils {
    public static final Comparator<ItemStack> ITEM_COMPARATOR = (item1, item2) -> {
        int cmp = item2.func_77973_b().hashCode() - item1.func_77973_b().hashCode();
        if (cmp != 0) {
            return cmp;
        }
        cmp = item2.func_77952_i() - item1.func_77952_i();
        if (cmp != 0) {
            return cmp;
        }
        CompoundNBT c1 = item1.func_77978_p();
        CompoundNBT c2 = item2.func_77978_p();
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        return c1.hashCode() - c2.hashCode();
    };

    public static ItemStack itemStackAmount(int amount, ItemStack stack, PlayerEntity player) {
        if (stack == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return stack;
        }
        stack.func_190920_e(stack.func_190916_E() + amount);
        if (stack.func_190916_E() <= 0) {
            stack.func_190920_e(0);
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() > stack.func_77976_d()) {
            stack.func_190920_e(stack.func_77976_d());
        }
        return stack;
    }

    public static ItemStack decrItemStack(ItemStack stack, PlayerEntity player) {
        return ItemUtils.itemStackAmount(-1, stack, player);
    }

    public static ItemStack incrItemStack(ItemStack stack, PlayerEntity player) {
        return ItemUtils.itemStackAmount(1, stack, player);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() == stack2.func_77973_b()) {
            return stack1.func_77952_i() == stack2.func_77952_i();
        }
        return false;
    }

    public static void saveInventory(CompoundNBT compound, String name, IInventory inv) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT slot = new CompoundNBT();
            slot.func_74768_a("Slot", i);
            inv.func_70301_a(i).func_77955_b(slot);
            tagList.add((Object)slot);
        }
        compound.func_218657_a(name, (INBT)tagList);
    }

    public static void saveInventory(CompoundNBT compound, String name, NonNullList<ItemStack> inv) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < inv.size(); ++i) {
            if (((ItemStack)inv.get(i)).func_190926_b()) continue;
            CompoundNBT slot = new CompoundNBT();
            slot.func_74768_a("Slot", i);
            ((ItemStack)inv.get(i)).func_77955_b(slot);
            tagList.add((Object)slot);
        }
        compound.func_218657_a(name, (INBT)tagList);
    }

    public static void saveItemList(CompoundNBT compound, String name, NonNullList<ItemStack> list) {
        ItemUtils.saveItemList(compound, name, list, true);
    }

    public static void saveItemList(CompoundNBT compound, String name, NonNullList<ItemStack> list, boolean includeEmpty) {
        ListNBT itemList = new ListNBT();
        for (ItemStack stack : list) {
            if (!includeEmpty && stack.func_190926_b()) continue;
            itemList.add((Object)stack.func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a(name, (INBT)itemList);
    }

    public static void readInventory(CompoundNBT compound, String name, IInventory inv) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        ListNBT tagList = compound.func_150295_c(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT slot = tagList.func_150305_b(i);
            int j = slot.func_74762_e("Slot");
            if (j < 0 || j >= inv.func_70302_i_()) continue;
            inv.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)slot));
        }
    }

    public static void readInventory(CompoundNBT compound, String name, NonNullList<ItemStack> inv) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        ListNBT tagList = compound.func_150295_c(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT slot = tagList.func_150305_b(i);
            int j = slot.func_74762_e("Slot");
            if (j < 0 || j >= inv.size()) continue;
            inv.set(j, (Object)ItemStack.func_199557_a((CompoundNBT)slot));
        }
    }

    public static NonNullList<ItemStack> readItemList(CompoundNBT compound, String name, boolean includeEmpty) {
        NonNullList items = NonNullList.func_191196_a();
        if (!compound.func_74764_b(name)) {
            return items;
        }
        ListNBT itemList = compound.func_150295_c(name, 10);
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack item = ItemStack.func_199557_a((CompoundNBT)itemList.func_150305_b(i));
            if (!includeEmpty) {
                if (item.func_190926_b()) continue;
                items.add((Object)item);
                continue;
            }
            items.add((Object)item);
        }
        return items;
    }

    public static NonNullList<ItemStack> readItemList(CompoundNBT compound, String name) {
        return ItemUtils.readItemList(compound, name, true);
    }

    public static void readItemList(CompoundNBT compound, String name, NonNullList<ItemStack> list) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        ListNBT itemList = compound.func_150295_c(name, 10);
        for (int i = 0; i < itemList.size() && i < list.size(); ++i) {
            list.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)itemList.func_150305_b(i)));
        }
    }

    public static void removeStackFromSlot(IInventory inventory, int index) {
        inventory.func_70299_a(index, ItemStack.field_190927_a);
    }

    public static boolean isStackable(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2) && stack1.func_77952_i() == stack2.func_77952_i();
    }

    public static CompoundNBT writeOverstackedItem(CompoundNBT compound, ItemStack stack) {
        stack.func_77955_b(compound);
        compound.func_82580_o("Count");
        compound.func_74768_a("Count", stack.func_190916_E());
        return compound;
    }

    public static ItemStack readOverstackedItem(CompoundNBT compound) {
        CompoundNBT data = compound.func_74737_b();
        int count = data.func_74762_e("Count");
        data.func_82580_o("Count");
        data.func_74774_a("Count", (byte)1);
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)data);
        stack.func_190920_e(count);
        return stack;
    }
}

