/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.inventory.ScreenBase;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import de.maxhenkel.corpse.net.MessageOpenAdditionalItems;
import de.maxhenkel.corpse.net.MessageTransferItems;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CorpseInventoryScreen
extends ScreenBase<CorpseInventoryContainer> {
    public static final ResourceLocation CORPSE_GUI_TEXTURE = new ResourceLocation("corpse", "textures/gui/inventory_corpse.png");
    public static final TranslationTextComponent TRANSFER_ITEMS = new TranslationTextComponent("button.corpse.transfer_items");
    public static final TranslationTextComponent ADDITIONAL_ITEMS = new TranslationTextComponent("button.corpse.additional_items");
    public static final Button.IPressable PRESS_TRANSFER_ITEMS = b -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageTransferItems());
    public static final Button.IPressable PRESS_ADDITIONAL_ITEMS = b -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenAdditionalItems());
    private static final int PADDING = 7;
    private static final int BUTTON_HEIGHT = 20;
    private PlayerInventory playerInventory;
    private CorpseEntity corpse;
    private Button takeItems;
    private Button additionalItems;

    public CorpseInventoryScreen(CorpseEntity corpse, PlayerInventory playerInventory, CorpseInventoryContainer container, ITextComponent title) {
        super(CORPSE_GUI_TEXTURE, container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.corpse = corpse;
        this.field_146999_f = 176;
        this.field_147000_g = 245;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateButtons();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.updateButtons();
    }

    protected void updateButtons() {
        this.field_230710_m_.clear();
        CorpseEntity corpse = ((CorpseInventoryContainer)this.field_147002_h).getCorpse();
        if (!corpse.isMainInventoryEmpty() && !corpse.isAdditionalInventoryEmpty()) {
            this.takeItems = this.addLeftButton((ITextComponent)TRANSFER_ITEMS, PRESS_TRANSFER_ITEMS);
            this.additionalItems = this.addRightButton((ITextComponent)ADDITIONAL_ITEMS, PRESS_ADDITIONAL_ITEMS);
        } else if (!corpse.isMainInventoryEmpty()) {
            this.takeItems = this.addCenterButton((ITextComponent)TRANSFER_ITEMS, PRESS_TRANSFER_ITEMS);
            this.additionalItems = null;
        } else if (!corpse.isAdditionalInventoryEmpty()) {
            this.takeItems = null;
            this.additionalItems = this.addCenterButton((ITextComponent)ADDITIONAL_ITEMS, PRESS_ADDITIONAL_ITEMS);
        }
        if (this.takeItems != null) {
            this.takeItems.field_230693_o_ = ((CorpseInventoryContainer)this.field_147002_h).isEditable();
        }
    }

    private Button addLeftButton(ITextComponent text, Button.IPressable pressable) {
        return (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 7, this.field_147009_r + 120, 80, 20, text, pressable));
    }

    private Button addRightButton(ITextComponent text, Button.IPressable pressable) {
        return (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f - 80 - 7, this.field_147009_r + 120, 80, 20, text, pressable));
    }

    private Button addCenterButton(ITextComponent text, Button.IPressable pressable) {
        return (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f / 2 - 50, this.field_147009_r + 120, 100, 20, text, pressable));
    }

    @Override
    public void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_243248_b(matrixStack, this.corpse.func_145748_c_(), 7.0f, 7.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.playerInventory.func_145748_c_(), 7.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }
}

