/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.virus;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.living.IPlayer;
import com.craftingdead.virus.IModDist;
import com.craftingdead.virus.action.VirusActionTypes;
import com.craftingdead.virus.client.ClientDist;
import com.craftingdead.virus.data.VirusItemTagsProvider;
import com.craftingdead.virus.enchantment.InfectionEnchantment;
import com.craftingdead.virus.enchantment.VirusEnchantments;
import com.craftingdead.virus.entity.ModEntityTypes;
import com.craftingdead.virus.entity.monster.AdvancedZombieEntity;
import com.craftingdead.virus.entity.monster.DoctorZombieEntity;
import com.craftingdead.virus.entity.monster.FastZombieEntity;
import com.craftingdead.virus.entity.monster.GiantZombieEntity;
import com.craftingdead.virus.entity.monster.PoliceZombieEntity;
import com.craftingdead.virus.entity.monster.TankZombieEntity;
import com.craftingdead.virus.entity.monster.WeakZombieEntity;
import com.craftingdead.virus.item.VirusItems;
import com.craftingdead.virus.potion.VirusEffects;
import com.craftingdead.virus.server.ServerDist;
import java.util.ListIterator;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="craftingdeadvirus")
public class CraftingDeadVirus {
    public static final String ID = "craftingdeadvirus";
    private static final float ZOMBIE_INFECTION_CHANCE = 0.1f;
    private static CraftingDeadVirus instance;
    private final IModDist modDist;

    public CraftingDeadVirus() {
        instance = this;
        this.modDist = (IModDist)DistExecutor.safeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleEntityAttributeCreation);
        modEventBus.addListener(this::handleGatherData);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModEntityTypes.initialize();
        modEventBus.addGenericListener(EntityType.class, ModEntityTypes::registerAll);
        VirusEnchantments.ENCHANTMENTS.register(modEventBus);
        VirusActionTypes.ACTION_TYPES.register(modEventBus);
        VirusItems.ITEMS.register(modEventBus);
        VirusEffects.EFFECTS.register(modEventBus);
    }

    public IModDist getModDist() {
        return this.modDist;
    }

    public CraftingDeadVirus getInstance() {
        return instance;
    }

    public static void infect(PlayerEntity playerEntity, float chance) {
        if (!playerEntity.func_184812_l_() && playerEntity.func_130014_f_().func_175659_aa() != Difficulty.PEACEFUL && playerEntity.func_70681_au().nextFloat() < chance && !playerEntity.func_70644_a((Effect)VirusEffects.INFECTION.get())) {
            playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("message.infected").func_230530_a_(Style.field_240709_b_.func_240720_a_(new TextFormatting[]{TextFormatting.RED}).func_240713_a_(Boolean.valueOf(true))), true);
            playerEntity.func_195064_c(new EffectInstance((Effect)VirusEffects.INFECTION.get(), 9999999));
        }
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.SYRINGE.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151153_ao, Items.field_196100_at}), (ItemStack)new ItemStack((IItemProvider)VirusItems.CURE_SYRINGE.get()));
    }

    private void handleEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put(ModEntityTypes.advancedZombie, AdvancedZombieEntity.registerAttributes().func_233813_a_());
        event.put(ModEntityTypes.doctorZombie, DoctorZombieEntity.registerAttributes().func_233813_a_());
        event.put(ModEntityTypes.fastZombie, FastZombieEntity.registerAttributes().func_233813_a_());
        event.put(ModEntityTypes.giantZombie, GiantZombieEntity.registerAttributes().func_233813_a_());
        event.put(ModEntityTypes.policeZombie, PoliceZombieEntity.registerAttributes().func_233813_a_());
        event.put(ModEntityTypes.tankZombie, TankZombieEntity.registerAttributes().func_233813_a_());
        event.put(ModEntityTypes.weakZombie, WeakZombieEntity.registerAttributes().func_233813_a_());
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            dataGenerator.func_200390_a((IDataProvider)new VirusItemTagsProvider(dataGenerator, (BlockTagsProvider)new ForgeBlockTagsProvider(dataGenerator, event.getExistingFileHelper()), event.getExistingFileHelper()));
        }
    }

    @SubscribeEvent
    public void handleGunHitEntity(GunEvent.HitEntity event) {
        event.getTarget().getCapability(ModCapabilities.LIVING).filter(living -> living instanceof IPlayer).map(living -> (IPlayer)living).ifPresent(living -> {
            float clothingProtectionPct = living.getItemHandler().getStackInSlot(InventorySlotType.CLOTHING.getIndex()).getCapability(ModCapabilities.CLOTHING).map(clothing -> Float.valueOf(clothing.hasEnhancedProtection() ? 0.5f : 0.0f)).orElse(Float.valueOf(1.0f)).floatValue();
            float enchantmentPct = (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)VirusEnchantments.INFECTION.get()), (ItemStack)event.getItemStack()) / (float)((InfectionEnchantment)VirusEnchantments.INFECTION.get()).func_77325_b();
            CraftingDeadVirus.infect((PlayerEntity)living.getEntity(), enchantmentPct + clothingProtectionPct);
        });
    }

    @SubscribeEvent
    public void handleLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity && event.getSource().func_76346_g() instanceof ZombieEntity) {
            CraftingDeadVirus.infect((PlayerEntity)entity, 0.1f);
        }
    }

    @SubscribeEvent
    public void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        switch (event.phase) {
            case START: {
                if (!event.player.func_184812_l_() && event.player.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL || !event.player.func_70644_a((Effect)VirusEffects.INFECTION.get())) break;
                event.player.func_195063_d((Effect)VirusEffects.INFECTION.get());
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleBiomeLoading(BiomeLoadingEvent event) {
        ListIterator<MobSpawnInfo.Spawners> iterator = event.getSpawns().getSpawner(EntityClassification.MONSTER).listIterator();
        while (iterator.hasNext()) {
            MobSpawnInfo.Spawners spawnEntry = (MobSpawnInfo.Spawners)iterator.next();
            if (spawnEntry.field_242588_c != EntityType.field_200725_aD) continue;
            iterator.add(new MobSpawnInfo.Spawners(ModEntityTypes.advancedZombie, spawnEntry.field_76292_a * 3, 2, 8));
            iterator.add(new MobSpawnInfo.Spawners(ModEntityTypes.fastZombie, spawnEntry.field_76292_a / 2, 2, 4));
            iterator.add(new MobSpawnInfo.Spawners(ModEntityTypes.tankZombie, spawnEntry.field_76292_a / 2, 2, 4));
            iterator.add(new MobSpawnInfo.Spawners(ModEntityTypes.advancedZombie, spawnEntry.field_76292_a, 3, 8));
            iterator.add(new MobSpawnInfo.Spawners(ModEntityTypes.weakZombie, spawnEntry.field_76292_a, 3, 12));
        }
    }
}

