/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.virus.entity.monster;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.entity.ai.FollowAttractiveGrenadeGoal;
import com.craftingdead.core.entity.ai.LookAtEntityGoal;
import com.craftingdead.core.entity.grenade.FlashGrenadeEntity;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.item.ClothingItem;
import com.craftingdead.core.item.HatItem;
import com.craftingdead.core.item.MeleeWeaponItem;
import com.craftingdead.core.item.ModItems;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class AdvancedZombieEntity
extends ZombieEntity
implements IRangedAttackMob {
    private static final float MELEE_CHANCE = 0.15f;
    private static final float CLOTHING_CHANCE = 0.25f;
    private static final float HAT_CHANCE = 0.05f;
    private static final DataParameter<Integer> TEXTURE_NUMBER = EntityDataManager.func_187226_a(AdvancedZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private RangedAttackGoal rangedAttackGoal;
    private long triggerPressedStartTime;

    public AdvancedZombieEntity(EntityType<? extends AdvancedZombieEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.rangedAttackGoal = new RangedAttackGoal(this, 1.0, 40, 20.0f){

            public boolean func_75250_a() {
                return super.func_75250_a() && AdvancedZombieEntity.this.getCapability(ModCapabilities.LIVING).map(living -> AdvancedZombieEntity.this.func_184614_ca().getCapability(ModCapabilities.GUN).isPresent()).orElse(false) != false;
            }
        };
        this.field_70714_bg.func_75776_a(2, (Goal)this.rangedAttackGoal);
        this.field_70714_bg.func_75776_a(1, (Goal)new FollowAttractiveGrenadeGoal((MobEntity)this, (double)1.15f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtEntityGoal((MobEntity)this, FlashGrenadeEntity.class, 20.0f, 0.35f));
    }

    public boolean func_213380_a(IWorld world, SpawnReason spawnReason) {
        return true;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return ZombieEntity.func_234342_eQ_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TEXTURE_NUMBER, (Object)0);
    }

    public int func_70658_aO() {
        int armorValue = super.func_70658_aO() + 2;
        if (armorValue > 20) {
            armorValue = 20;
        }
        return armorValue;
    }

    public int func_70641_bl() {
        return 12;
    }

    protected boolean func_190730_o() {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(TEXTURE_NUMBER, (Object)compound.func_74762_e("textureNumber"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("textureNumber", ((Integer)this.field_70180_af.func_187225_a(TEXTURE_NUMBER)).intValue());
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.field_70180_af.func_187227_b(TEXTURE_NUMBER, (Object)this.field_70146_Z.nextInt(23));
        this.func_184201_a(EquipmentSlotType.MAINHAND, this.getHeldStack());
        this.getCapability(ModCapabilities.LIVING).ifPresent(living -> {
            living.getItemHandler().setStackInSlot(InventorySlotType.CLOTHING.getIndex(), this.getClothingStack());
            living.getItemHandler().setStackInSlot(InventorySlotType.HAT.getIndex(), this.getHatStack());
        });
    }

    protected ItemStack getHeldStack() {
        return this.getRandomItem(item -> item instanceof MeleeWeaponItem, 0.15f).map(Item::func_190903_i).orElse(ItemStack.field_190927_a);
    }

    protected ItemStack getClothingStack() {
        return this.getRandomItem(item -> item instanceof ClothingItem, 0.25f).map(Item::func_190903_i).orElse(ItemStack.field_190927_a);
    }

    protected ItemStack getHatStack() {
        return this.getRandomItem(item -> item instanceof HatItem, 0.05f).map(Item::func_190903_i).orElse(ItemStack.field_190927_a);
    }

    protected Optional<Item> getRandomItem(Predicate<Item> predicate, float probability) {
        if (this.field_70146_Z.nextFloat() < probability) {
            List items = ModItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(predicate).collect(Collectors.toList());
            return Optional.of(items.get(this.field_70146_Z.nextInt(items.size())));
        }
        return Optional.empty();
    }

    public int getTextureNumber() {
        return (Integer)this.field_70180_af.func_187225_a(TEXTURE_NUMBER);
    }

    public static boolean areSpawnConditionsMet(EntityType<?> entityType, IWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().func_201670_d()) {
            this.getCapability(ModCapabilities.LIVING).ifPresent(living -> this.func_184614_ca().getCapability(ModCapabilities.GUN).ifPresent(gun -> {
                if (gun.isTriggerPressed() && (!this.rangedAttackGoal.func_75253_b() || Util.func_211177_b() - this.triggerPressedStartTime > (long)(1000 + this.field_70146_Z.nextInt(2000)))) {
                    gun.setTriggerPressed(living, false, true);
                }
            }));
        }
    }

    public void func_82196_d(LivingEntity livingEntity, float distance) {
        if (!this.field_70170_p.func_201670_d()) {
            this.getCapability(ModCapabilities.LIVING).ifPresent(living -> this.func_184614_ca().getCapability(ModCapabilities.GUN).ifPresent(gun -> {
                this.triggerPressedStartTime = Util.func_211177_b();
                gun.setTriggerPressed(living, true, true);
            }));
        }
    }
}

