/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Server {
        public ForgeConfigSpec.BooleanValue allowCodebreakerItem;
        public ForgeConfigSpec.BooleanValue allowAdminTool;
        public ForgeConfigSpec.BooleanValue shouldSpawnFire;
        public ForgeConfigSpec.BooleanValue ableToBreakMines;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard1;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard2;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard3;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard4;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard5;
        public ForgeConfigSpec.BooleanValue ableToCraftLUKeycard;
        public ForgeConfigSpec.BooleanValue smallerMineExplosion;
        public ForgeConfigSpec.BooleanValue mineExplodesWhenInCreative;
        public ForgeConfigSpec.IntValue laserBlockRange;
        public ForgeConfigSpec.IntValue inventoryScannerRange;
        public ForgeConfigSpec.IntValue maxAlarmRange;
        public ForgeConfigSpec.BooleanValue allowBlockClaim;
        public ForgeConfigSpec.BooleanValue respectInvisibility;
        public ForgeConfigSpec.BooleanValue reinforcedBlockTint;
        public ForgeConfigSpec.BooleanValue ableToCraftMines;
        public ForgeConfigSpec.BooleanValue retinalScannerFace;

        Server(ForgeConfigSpec.Builder builder) {
            this.allowCodebreakerItem = builder.translation("config.securitycraft:isCodebreakerAllowed").comment("Can the codebreaker be used?").define("allowCodebreakerItem", true);
            this.allowAdminTool = builder.translation("config.securitycraft:allowAdminTool").comment("Can the admin tool be used?").define("allowAdminTool", false);
            this.shouldSpawnFire = builder.translation("config.securitycraft:shouldSpawnFire").comment("Should mines spawn fire after exploding?").define("shouldSpawnFire", true);
            this.ableToBreakMines = builder.translation("config.securitycraft:ableToBreakMines").comment("Should players be able to break a mine without it exploding?").worldRestart().define("ableToBreakMines", true);
            this.ableToCraftKeycard1 = builder.translation("config.securitycraft:ableToCraftKeycard1").comment("Is the level 1 keycard craftable?").worldRestart().define("ableToCraftKeycard1", true);
            this.ableToCraftKeycard2 = builder.translation("config.securitycraft:ableToCraftKeycard2").comment("Is the level 2 keycard craftable?").worldRestart().define("ableToCraftKeycard2", true);
            this.ableToCraftKeycard3 = builder.translation("config.securitycraft:ableToCraftKeycard3").comment("Is the level 3 keycard craftable?").worldRestart().define("ableToCraftKeycard3", true);
            this.ableToCraftKeycard4 = builder.translation("config.securitycraft:ableToCraftKeycard4").comment("Is the level 4 keycard craftable?").worldRestart().define("ableToCraftKeycard4", true);
            this.ableToCraftKeycard5 = builder.translation("config.securitycraft:ableToCraftKeycard5").comment("Is the level 5 keycard craftable?").worldRestart().define("ableToCraftKeycard5", true);
            this.ableToCraftLUKeycard = builder.translation("config.securitycraft:ableToCraftLUKeycard").comment("Is the limited use keycard craftable?").worldRestart().define("ableToCraftLUKeycard", true);
            this.smallerMineExplosion = builder.translation("config.securitycraft:smallerMineExplosion").comment("Should mines' explosions be smaller than usual.").define("smallerMineExplosion", false);
            this.mineExplodesWhenInCreative = builder.translation("config.securitycraft:mineExplodesWhenInCreative").comment("Should mines explode if broken while in Creative mode?").define("mineExplodesWhenInCreative", true);
            this.laserBlockRange = builder.translation("config.securitycraft:laserBlockRange").comment("From how many blocks away can a laser block connect to another laser block?").defineInRange("laserBlockRange", 5, 0, Integer.MAX_VALUE);
            this.inventoryScannerRange = builder.translation("config.securitycraft:inventoryScannerRange").comment("From how many blocks away can an inventory scanner connect to another inventory scanner?").defineInRange("inventoryScannerRange", 2, 0, Integer.MAX_VALUE);
            this.maxAlarmRange = builder.translation("config.securitycraft:maxAlarmRange").comment("What is the maximum value that can be set for an alarm's range option? Do note, that this may be limited by chunk loading distance. Higher values may also not be finetuneable.").defineInRange("maxAlarmRange", 100, 1, Integer.MAX_VALUE);
            this.allowBlockClaim = builder.translation("config.securitycraft:allowBlockClaim").comment("Allow claiming unowned blocks?").define("allowBlockClaim", false);
            this.respectInvisibility = builder.translation("config.securitycraft:respectInvisibility").comment("Should the sentry/inventory scanner/laser block/etc. ignore players and entities that are invisible?").define("respect_invisibility", false);
            this.reinforcedBlockTint = builder.translation("config.securitycraft:reinforcedBlockTint").comment("Should reinforced blocks' textures be slightly darker than their vanilla counterparts?").define("reinforced_block_tint", true);
            this.ableToCraftMines = builder.translation("config.securitycraft:ableToCraftMines").comment("Are all mines craftable?").define("ableToCraftMines", true);
            this.retinalScannerFace = builder.translation("config.securitycraft:retinalScannerFace").comment("Display owner face on retinal scanner?").define("retinalScannerFace", true);
        }
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue sayThanksMessage;
        public ForgeConfigSpec.DoubleValue cameraSpeed;

        Client(ForgeConfigSpec.Builder builder) {
            this.sayThanksMessage = builder.translation("config.securitycraft:sayThanksMessage").comment("Display a 'tip' message at spawn?").define("sayThanksMessage", true);
            this.cameraSpeed = builder.translation("config.securitycraft:cameraSpeed").comment("How fast can you rotate when mounted to a camera and holding W-A-S-D?").defineInRange("cameraSpeed", 2.0, 0.0, Double.MAX_VALUE);
        }
    }
}

