/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.SecurityCameraEntity;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("minecraft:textures/mob_effect/night_vision.png");
    private static final ItemStack REDSTONE = new ItemStack((IItemProvider)Items.field_151137_ax);

    @SubscribeEvent
    public static void onPlayerRendered(RenderPlayerEvent.Pre event) {
        if (event.getEntity() instanceof LivingEntity && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawHighlightEvent.HighlightBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_233580_cy_().equals((Object)event.getTarget().func_216350_a())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && Minecraft.func_71410_x().field_71439_g != null && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g)) {
            if (BlockUtils.getBlock((IBlockReader)Minecraft.func_71410_x().field_71441_e, BlockUtils.toPos((int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_226277_ct_()), (int)Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_226278_cu_(), (int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_226281_cx_()))) instanceof SecurityCameraBlock) {
                SCClientEventHandler.drawCameraOverlay(event.getMatrixStack(), Minecraft.func_71410_x(), (AbstractGui)Minecraft.func_71410_x().field_71456_v, Minecraft.func_71410_x().func_228018_at_(), (PlayerEntity)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, BlockUtils.toPos((int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_226277_ct_()), (int)Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_226278_cu_(), (int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_226281_cx_())));
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            World world = player.func_130014_f_();
            int held = player.field_71071_by.field_70461_c;
            if (held < 0 || held >= player.field_71071_by.field_70462_a.size()) {
                return;
            }
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(held);
            if (!stack.func_190926_b() && stack.func_77973_b() == SCContent.CAMERA_MONITOR.get()) {
                String textureToUse = "item_not_bound";
                double eyeHeight = player.func_70047_e();
                Vector3d lookVec = new Vector3d(player.func_226277_ct_() + player.func_70040_Z().field_72450_a * 5.0, eyeHeight + player.func_226278_cu_() + player.func_70040_Z().field_72448_b * 5.0, player.func_226281_cx_() + player.func_70040_Z().field_72449_c * 5.0);
                BlockRayTraceResult mop = world.func_217299_a(new RayTraceContext(new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_()), lookVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
                if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_175625_s(mop.func_216350_a()) instanceof SecurityCameraTileEntity) {
                    CompoundNBT cameras = stack.func_77978_p();
                    if (cameras != null) {
                        for (int i = 1; i < 31; ++i) {
                            String[] coords;
                            if (!cameras.func_74764_b("Camera" + i) || Integer.parseInt((coords = cameras.func_74779_i("Camera" + i).split(" "))[0]) != mop.func_216350_a().func_177958_n() || Integer.parseInt(coords[1]) != mop.func_216350_a().func_177956_o() || Integer.parseInt(coords[2]) != mop.func_216350_a().func_177952_p()) continue;
                            textureToUse = "item_bound";
                            break;
                        }
                    }
                    RenderSystem.enableAlphaTest();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("securitycraft", "textures/gui/" + textureToUse + ".png"));
                    AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 - 90 + held * 20 + 2), (int)(Minecraft.func_71410_x().func_228018_at_().func_198087_p() - 16 - 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                    RenderSystem.disableAlphaTest();
                }
            } else if (!stack.func_190926_b() && stack.func_77973_b() == SCContent.REMOTE_ACCESS_MINE.get()) {
                String textureToUse = "item_not_bound";
                double eyeHeight = player.func_70047_e();
                Vector3d lookVec = new Vector3d(player.func_226277_ct_() + player.func_70040_Z().field_72450_a * 5.0, eyeHeight + player.func_226278_cu_() + player.func_70040_Z().field_72448_b * 5.0, player.func_226281_cx_() + player.func_70040_Z().field_72449_c * 5.0);
                BlockRayTraceResult mop = world.func_217299_a(new RayTraceContext(new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_()), lookVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
                if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_180495_p(mop.func_216350_a()).func_177230_c() instanceof IExplosive) {
                    CompoundNBT mines = stack.func_77978_p();
                    if (mines != null) {
                        for (int i = 1; i <= 6; ++i) {
                            int[] coords;
                            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = mines.func_74759_k("mine" + i))[0] != mop.func_216350_a().func_177958_n() || coords[1] != mop.func_216350_a().func_177956_o() || coords[2] != mop.func_216350_a().func_177952_p()) continue;
                            textureToUse = "item_bound";
                            break;
                        }
                    }
                    RenderSystem.enableAlphaTest();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("securitycraft", "textures/gui/" + textureToUse + ".png"));
                    AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 - 90 + held * 20 + 2), (int)(Minecraft.func_71410_x().func_228018_at_().func_198087_p() - 16 - 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                    RenderSystem.disableAlphaTest();
                }
            } else if (!stack.func_190926_b() && stack.func_77973_b() == SCContent.REMOTE_ACCESS_SENTRY.get()) {
                String textureToUse = "item_not_bound";
                Entity hitEntity = Minecraft.func_71410_x().field_147125_j;
                if (hitEntity instanceof SentryEntity) {
                    CompoundNBT sentries = stack.func_77978_p();
                    if (sentries != null) {
                        for (int i = 1; i <= 12; ++i) {
                            int[] coords;
                            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = sentries.func_74759_k("sentry" + i))[0] != hitEntity.func_233580_cy_().func_177958_n() || coords[1] != hitEntity.func_233580_cy_().func_177956_o() || coords[2] != hitEntity.func_233580_cy_().func_177952_p()) continue;
                            textureToUse = "item_bound";
                            break;
                        }
                    }
                    RenderSystem.enableAlphaTest();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("securitycraft", "textures/gui/" + textureToUse + ".png"));
                    AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 - 90 + held * 20 + 2), (int)(Minecraft.func_71410_x().func_228018_at_().func_198087_p() - 16 - 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                    RenderSystem.disableAlphaTest();
                }
            }
        }
    }

    @SubscribeEvent
    public static void fovUpdateEvent(FOVUpdateEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setNewfov(((SecurityCameraEntity)event.getEntity().func_184187_bx()).getZoomAmount());
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (Minecraft.func_71410_x().field_71441_e != null && event.getButton() != 1 && Minecraft.func_71410_x().field_71439_g.field_71070_bA == null && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g().func_77973_b() != SCContent.CAMERA_MONITOR.get()) {
            event.setCanceled(true);
        }
    }

    private static void drawCameraOverlay(MatrixStack matrix, Minecraft mc, AbstractGui gui, MainWindow resolution, PlayerEntity player, World world, BlockPos pos) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        SecurityCameraTileEntity te = (SecurityCameraTileEntity)world.func_175625_s(pos);
        boolean hasRedstoneModule = te.hasModule(ModuleType.REDSTONE);
        TranslationTextComponent exit = ClientUtils.localize("gui.securitycraft:camera.exit", settings.field_228046_af_.func_238171_j_());
        TranslationTextComponent zoom = ClientUtils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.func_238171_j_(), KeyBindings.cameraZoomOut.func_238171_j_());
        TranslationTextComponent nightVision = ClientUtils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.func_238171_j_());
        TranslationTextComponent redstone = ClientUtils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.func_238171_j_());
        TranslationTextComponent redstoneNote = ClientUtils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);
        String time = ClientUtils.getFormattedMinecraftTime();
        int timeY = 25;
        if (te.hasCustomSCName()) {
            ITextComponent cameraName = te.getCustomSCName();
            font.func_243246_a(matrix, cameraName, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)cameraName) - 8), 25.0f, 0xFFFFFF);
            timeY += 10;
        }
        font.func_238405_a_(matrix, time, (float)(resolution.func_198107_o() - font.func_78256_a(time) - 8), (float)timeY, 0xFFFFFF);
        font.func_243246_a(matrix, (ITextComponent)exit, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)exit) - 8), (float)(resolution.func_198087_p() - 70), 0xFFFFFF);
        font.func_243246_a(matrix, (ITextComponent)zoom, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)zoom) - 8), (float)(resolution.func_198087_p() - 60), 0xFFFFFF);
        font.func_243246_a(matrix, (ITextComponent)nightVision, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)nightVision) - 8), (float)(resolution.func_198087_p() - 50), 0xFFFFFF);
        font.func_243246_a(matrix, (ITextComponent)redstone, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)redstone) - 8), (float)(resolution.func_198087_p() - 40), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        font.func_243246_a(matrix, (ITextComponent)redstoneNote, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)redstoneNote) - 8), (float)(resolution.func_198087_p() - 30), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        mc.func_110434_K().func_110577_a(CAMERA_DASHBOARD);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_238474_b_(matrix, 5, 0, 0, 0, 90, 20);
        gui.func_238474_b_(matrix, resolution.func_198107_o() - 55, 5, 205, 0, 50, 30);
        if (!player.func_70644_a(Effects.field_76439_r)) {
            gui.func_238474_b_(matrix, 28, 4, 90, 12, 16, 11);
        } else {
            mc.func_110434_K().func_110577_a(NIGHT_VISION);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)27, (int)-1, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            mc.func_110434_K().func_110577_a(CAMERA_DASHBOARD);
        }
        if (world.func_180495_p(pos).func_185911_a((IBlockReader)world, pos, (Direction)BlockUtils.getBlockProperty(world, pos, SecurityCameraBlock.FACING)) == 0 && !te.hasModule(ModuleType.REDSTONE)) {
            gui.func_238474_b_(matrix, 12, 2, 104, 0, 12, 12);
        } else if (world.func_180495_p(pos).func_185911_a((IBlockReader)world, pos, (Direction)BlockUtils.getBlockProperty(world, pos, SecurityCameraBlock.FACING)) == 0 && te.hasModule(ModuleType.REDSTONE)) {
            gui.func_238474_b_(matrix, 12, 3, 90, 0, 12, 11);
        } else {
            Minecraft.func_71410_x().func_175599_af().func_180450_b(REDSTONE, 10, 0);
        }
    }
}

