/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.SecurityCraftTileEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IWorld;

public abstract class CustomizableTileEntity
extends SecurityCraftTileEntity
implements IModuleInventory,
ICustomizable {
    private boolean linkable = false;
    public ArrayList<LinkedBlock> linkedBlocks = new ArrayList();
    private ListNBT nbtTagStorage = null;
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);

    public CustomizableTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145830_o() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            this.sync();
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        if (tag.func_74764_b("linkable")) {
            this.linkable = tag.func_74767_n("linkable");
        }
        if (this.linkable && tag.func_74764_b("linkedBlocks")) {
            if (!this.func_145830_o()) {
                this.nbtTagStorage = tag.func_150295_c("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.func_150295_c("linkedBlocks", 10));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        tag.func_74757_a("linkable", this.linkable);
        if (this.linkable && this.func_145830_o() && this.linkedBlocks.size() > 0) {
            ListNBT tagList = new ListNBT();
            WorldUtils.addScheduledTask((IWorld)this.field_145850_b, () -> {
                for (int i = this.linkedBlocks.size() - 1; i >= 0; --i) {
                    LinkedBlock block = this.linkedBlocks.get(i);
                    CompoundNBT toAppend = new CompoundNBT();
                    if (block != null) {
                        if (!block.validate(this.field_145850_b)) {
                            this.linkedBlocks.remove(i);
                            continue;
                        }
                        toAppend.func_74778_a("blockName", block.blockName);
                        toAppend.func_74768_a("blockX", block.getX());
                        toAppend.func_74768_a("blockY", block.getY());
                        toAppend.func_74768_a("blockZ", block.getZ());
                    }
                    tagList.add((Object)toAppend);
                }
                tag.func_218657_a("linkedBlocks", (INBT)tagList);
            });
        }
        return tag;
    }

    private void readLinkedBlocks(ListNBT list) {
        if (!this.linkable) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String name = list.func_150305_b(i).func_74779_i("blockName");
            int x = list.func_150305_b(i).func_74762_e("blockX");
            int y = list.func_150305_b(i).func_74762_e("blockY");
            int z = list.func_150305_b(i).func_74762_e("blockZ");
            LinkedBlock block = new LinkedBlock(name, x, y, z);
            if (this.func_145830_o() && !block.validate(this.field_145850_b)) {
                list.remove(i);
                continue;
            }
            if (this.linkedBlocks.contains(block)) continue;
            CustomizableTileEntity.link(this, block.asTileEntity(this.field_145850_b));
        }
    }

    @Override
    public boolean hasCustomSCName() {
        return this.getCustomSCName() != null && !this.getCustomSCName().getString().equals("name");
    }

    @Override
    public void onTileEntityDestroyed() {
        if (this.linkable) {
            for (LinkedBlock block : this.linkedBlocks) {
                CustomizableTileEntity.unlink(block.asTileEntity(this.field_145850_b), this);
            }
        }
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleInserted(stack, module);
        ModuleUtils.createLinkedAction(LinkedAction.MODULE_INSERTED, stack, this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleRemoved(stack, module);
        ModuleUtils.createLinkedAction(LinkedAction.MODULE_REMOVED, stack, this);
    }

    public CustomizableTileEntity linkable() {
        this.linkable = true;
        return this;
    }

    public boolean canBeLinkedWith() {
        return this.linkable;
    }

    public static void link(CustomizableTileEntity tileEntity1, CustomizableTileEntity tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        if (CustomizableTileEntity.isLinkedWith(tileEntity1, tileEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(tileEntity1);
        LinkedBlock block2 = new LinkedBlock(tileEntity2);
        if (!tileEntity1.linkedBlocks.contains(block2)) {
            tileEntity1.linkedBlocks.add(block2);
        }
        if (!tileEntity2.linkedBlocks.contains(block1)) {
            tileEntity2.linkedBlocks.add(block1);
        }
    }

    public static void unlink(CustomizableTileEntity tileEntity1, CustomizableTileEntity tileEntity2) {
        if (tileEntity1 == null || tileEntity2 == null) {
            return;
        }
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        LinkedBlock block = new LinkedBlock(tileEntity2);
        if (tileEntity1.linkedBlocks.contains(block)) {
            tileEntity1.linkedBlocks.remove(block);
        }
    }

    public static boolean isLinkedWith(CustomizableTileEntity tileEntity1, CustomizableTileEntity tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return false;
        }
        return tileEntity1.linkedBlocks.contains(new LinkedBlock(tileEntity2)) && tileEntity2.linkedBlocks.contains(new LinkedBlock(tileEntity1));
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        this.createLinkedBlockAction(LinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, this);
    }

    public void createLinkedBlockAction(LinkedAction action, Object[] parameters, CustomizableTileEntity excludedTE) {
        ArrayList<CustomizableTileEntity> list = new ArrayList<CustomizableTileEntity>();
        list.add(excludedTE);
        this.createLinkedBlockAction(action, parameters, list);
    }

    public void createLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<CustomizableTileEntity> excludedTEs) {
        if (!this.linkable) {
            return;
        }
        for (LinkedBlock block : this.linkedBlocks) {
            if (excludedTEs.contains(block.asTileEntity(this.field_145850_b))) continue;
            block.asTileEntity(this.field_145850_b).onLinkedBlockAction(action, parameters, excludedTEs);
            block.asTileEntity(this.field_145850_b).sync();
        }
    }

    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<CustomizableTileEntity> excludedTEs) {
    }
}

