/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.items.BaseKeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KeycardReaderBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public KeycardReaderBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void insertCard(World world, BlockPos pos, ItemStack stack, PlayerEntity player) {
        if (ModuleUtils.checkForModule(world, pos, player, ModuleType.BLACKLIST)) {
            return;
        }
        boolean whitelisted = ModuleUtils.checkForModule(world, pos, player, ModuleType.WHITELIST);
        int requiredLevel = -1;
        int cardLvl = ((BaseKeycardItem)stack.func_77973_b()).getKeycardLvl();
        KeycardReaderTileEntity te = (KeycardReaderTileEntity)world.func_175625_s(pos);
        boolean exact = te.doesRequireExactKeycard();
        if (te.getPassword() != null) {
            requiredLevel = Integer.parseInt(te.getPassword());
        }
        if (whitelisted || !exact && requiredLevel <= cardLvl || exact && requiredLevel == cardLvl) {
            if (cardLvl == 6 && stack.func_77978_p() != null && !player.func_184812_l_()) {
                stack.func_77978_p().func_74768_a("Uses", stack.func_77978_p().func_74762_e("Uses") - 1);
                if (stack.func_77978_p().func_74762_e("Uses") <= 0) {
                    stack.func_190918_g(1);
                }
            }
            KeycardReaderBlock.activate(world, pos, te.getSignalLength());
        } else if (world.field_72995_K) {
            if (requiredLevel == -1) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYCARD_READER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:keycardReader.notSet", new Object[0]), TextFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYCARD_READER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:keycardReader.required", te.getPassword(), ((BaseKeycardItem)stack.func_77973_b()).getKeycardLvl()), TextFormatting.RED);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.field_71071_by.func_70448_g().func_190926_b() || !(player.field_71071_by.func_70448_g().func_77973_b() instanceof BaseKeycardItem) && player.field_71071_by.func_70448_g().func_77973_b() != SCContent.ADMIN_TOOL.get()) {
            ((KeycardReaderTileEntity)world.func_175625_s(pos)).openPasswordGUI(player);
        } else if (player.field_71071_by.func_70448_g().func_77973_b() == SCContent.ADMIN_TOOL.get()) {
            ((KeycardReaderBlock)BlockUtils.getBlock((IBlockReader)world, pos)).insertCard(world, pos, new ItemStack((IItemProvider)SCContent.LIMITED_USE_KEYCARD.get(), 1), player);
        } else {
            ((KeycardReaderBlock)BlockUtils.getBlock((IBlockReader)world, pos)).insertCard(world, pos, player.field_71071_by.func_70448_g(), player);
        }
        return ActionResultType.SUCCESS;
    }

    public static void activate(World world, BlockPos pos, int signalLength) {
        BlockUtils.setBlockProperty(world, pos, POWERED, true);
        world.func_195593_d(pos, (Block)SCContent.KEYCARD_READER.get());
        world.func_205220_G_().func_205360_a(pos, (Object)SCContent.KEYCARD_READER.get(), signalLength);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty((World)world, pos, POWERED, false);
            world.func_195593_d(pos, (Block)SCContent.KEYCARD_READER.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d())).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{POWERED});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KeycardReaderTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }
}

