/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.tileentity.LaserBlockTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LaserBlock
extends DisguisableBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public LaserBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        if (!world.field_72995_K) {
            this.setLaser(world, pos);
        }
    }

    public void setLaser(World world, BlockPos pos) {
        block0: for (Direction facing : Direction.values()) {
            int boundType = facing == Direction.UP || facing == Direction.DOWN ? 1 : (facing == Direction.NORTH || facing == Direction.SOUTH ? 2 : 3);
            for (int i = 1; i <= (Integer)ConfigHandler.SERVER.laserBlockRange.get(); ++i) {
                BlockPos offsetPos = pos.func_177967_a(facing, i);
                BlockState offsetState = world.func_180495_p(offsetPos);
                Block offsetBlock = offsetState.func_177230_c();
                if (!offsetState.isAir((IBlockReader)world, offsetPos) && offsetBlock != SCContent.LASER_BLOCK.get()) continue block0;
                if (offsetBlock != SCContent.LASER_BLOCK.get()) continue;
                LaserBlockTileEntity thisTe = (LaserBlockTileEntity)world.func_175625_s(pos);
                LaserBlockTileEntity thatTe = (LaserBlockTileEntity)world.func_175625_s(offsetPos);
                if (!thisTe.getOwner().equals(thatTe.getOwner())) continue block0;
                CustomizableTileEntity.link(thisTe, thatTe);
                if (!thisTe.isEnabled() || !thatTe.isEnabled()) continue block0;
                for (int j = 1; j < i; ++j) {
                    offsetPos = pos.func_177967_a(facing, j);
                    if (!world.func_180495_p(offsetPos).isAir((IBlockReader)world, offsetPos)) continue;
                    world.func_175656_a(offsetPos, (BlockState)((Block)SCContent.LASER_FIELD.get()).func_176223_P().func_206870_a((Property)LaserFieldBlock.BOUNDTYPE, (Comparable)Integer.valueOf(boundType)));
                }
                continue block0;
            }
        }
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        if (!world.func_201670_d()) {
            LaserBlock.destroyAdjacentLasers(world, pos);
        }
    }

    public static void destroyAdjacentLasers(IWorld world, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            BlockPos offsetPos;
            BlockState state;
            int boundType = facing == Direction.UP || facing == Direction.DOWN ? 1 : (facing == Direction.NORTH || facing == Direction.SOUTH ? 2 : 3);
            for (int i = 1; i <= (Integer)ConfigHandler.SERVER.laserBlockRange.get() && (state = world.func_180495_p(offsetPos = pos.func_177967_a(facing, i))).func_177230_c() != SCContent.LASER_BLOCK.get(); ++i) {
                if (state.func_177230_c() != SCContent.LASER_FIELD.get() || (Integer)state.func_177229_b((Property)LaserFieldBlock.BOUNDTYPE) != boundType) continue;
                world.func_175655_b(offsetPos, false);
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        this.setLaser(world, pos);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            BlockUtils.setBlockProperty((World)world, pos, POWERED, false, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new LaserBlockTileEntity().linkable();
    }
}

