/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PanicButtonBlock
extends AbstractButtonBlock {
    private static final VoxelShape FLOOR_NS_POWERED = Block.func_208617_a((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0);
    private static final VoxelShape FLOOR_NS_UNPOWERED = Block.func_208617_a((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)2.0, (double)11.0);
    private static final VoxelShape FLOOR_EW_POWERED = Block.func_208617_a((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)13.0);
    private static final VoxelShape FLOOR_EW_UNPOWERED = Block.func_208617_a((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)2.0, (double)13.0);
    private static final VoxelShape WALL_N_POWERED = Block.func_208617_a((double)3.0, (double)5.0, (double)15.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_N_UNPOWERED = Block.func_208617_a((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_S_POWERED = Block.func_208617_a((double)3.0, (double)5.0, (double)1.0, (double)13.0, (double)11.0, (double)0.0);
    private static final VoxelShape WALL_S_UNPOWERED = Block.func_208617_a((double)3.0, (double)5.0, (double)2.0, (double)13.0, (double)11.0, (double)0.0);
    private static final VoxelShape WALL_E_POWERED = Block.func_208617_a((double)1.0, (double)5.0, (double)3.0, (double)0.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_E_UNPOWERED = Block.func_208617_a((double)2.0, (double)5.0, (double)3.0, (double)0.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_POWERED = Block.func_208617_a((double)15.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_UNPOWERED = Block.func_208617_a((double)14.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape CEILING_NS_POWERED = Block.func_208617_a((double)3.0, (double)15.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_NS_UNPOWERED = Block.func_208617_a((double)3.0, (double)14.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_EW_POWERED = Block.func_208617_a((double)5.0, (double)15.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);
    private static final VoxelShape CEILING_EW_UNPOWERED = Block.func_208617_a((double)5.0, (double)14.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);

    public PanicButtonBlock(boolean isWooden, AbstractBlock.Properties properties) {
        super(isWooden, properties);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean newPowered = (Boolean)state.func_177229_b((Property)field_176584_b) == false;
        BlockUtils.setBlockProperty(world, pos, field_176584_b, newPowered, true);
        this.func_196367_a(player, (IWorld)world, pos, newPowered);
        if (state.func_177229_b((Property)field_196366_M) == AttachFace.WALL) {
            this.notifyNeighbors(world, pos, (Direction)state.func_177229_b((Property)field_185512_D));
        } else if (state.func_177229_b((Property)field_196366_M) == AttachFace.CEILING) {
            this.notifyNeighbors(world, pos, Direction.DOWN);
        } else if (state.func_177229_b((Property)field_196366_M) == AttachFace.FLOOR) {
            this.notifyNeighbors(world, pos, Direction.UP);
        }
        return ActionResultType.SUCCESS;
    }

    private void notifyNeighbors(World world, BlockPos pos, Direction facing) {
        world.func_195593_d(pos, (Block)this);
        world.func_195593_d(pos.func_177972_a(facing.func_176734_d()), (Block)this);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.func_175713_t(pos);
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.func_177229_b((Property)field_176584_b)).booleanValue()) {
                            return FLOOR_NS_POWERED;
                        }
                        return FLOOR_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.func_177229_b((Property)field_176584_b)).booleanValue()) {
                            return FLOOR_EW_POWERED;
                        }
                        return FLOOR_EW_UNPOWERED;
                    }
                }
                break;
            }
            case WALL: {
                switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                    case NORTH: {
                        if (((Boolean)state.func_177229_b((Property)field_176584_b)).booleanValue()) {
                            return WALL_N_POWERED;
                        }
                        return WALL_N_UNPOWERED;
                    }
                    case SOUTH: {
                        if (((Boolean)state.func_177229_b((Property)field_176584_b)).booleanValue()) {
                            return WALL_S_POWERED;
                        }
                        return WALL_S_UNPOWERED;
                    }
                    case EAST: {
                        if (((Boolean)state.func_177229_b((Property)field_176584_b)).booleanValue()) {
                            return WALL_E_POWERED;
                        }
                        return WALL_E_UNPOWERED;
                    }
                    case WEST: {
                        if (((Boolean)state.func_177229_b((Property)field_176584_b)).booleanValue()) {
                            return WALL_W_POWERED;
                        }
                        return WALL_W_UNPOWERED;
                    }
                }
                break;
            }
            case CEILING: {
                switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.func_177229_b((Property)field_176584_b)).booleanValue()) {
                            return CEILING_NS_POWERED;
                        }
                        return CEILING_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.func_177229_b((Property)field_176584_b)).booleanValue()) {
                            return CEILING_EW_POWERED;
                        }
                        return CEILING_EW_UNPOWERED;
                    }
                }
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197880_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableTileEntity();
    }

    protected SoundEvent func_196369_b(boolean turningOn) {
        return turningOn ? SoundEvents.field_187839_fV : SoundEvents.field_187837_fU;
    }
}

