/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.api.SecurityCraftTileEntity;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedFenceGateBlock
extends FenceGateBlock
implements IIntersectable {
    public ReinforcedFenceGateBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return ActionResultType.FAIL;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (((Boolean)BlockUtils.getBlockProperty(world, pos, field_176466_a)).booleanValue()) {
            return;
        }
        if (entity instanceof ItemEntity) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (((OwnableTileEntity)world.func_175625_s(pos)).getOwner().isOwner(player)) {
                return;
            }
        } else if (!world.field_72995_K && entity instanceof CreeperEntity) {
            CreeperEntity creeper = (CreeperEntity)entity;
            LightningBoltEntity lightning = WorldUtils.createLightning(world, Vector3d.func_237492_c_((Vector3i)pos), true);
            creeper.func_241841_a((ServerWorld)world, lightning);
            return;
        }
        entity.func_70097_a(CustomDamageSources.ELECTRICITY, 6.0f);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        boolean isPoweredSCBlock;
        if (!world.field_72995_K && ((isPoweredSCBlock = BlockUtils.hasActiveSCBlockNextTo(world, pos)) || block.func_176223_P().func_185897_m())) {
            if (isPoweredSCBlock && !((Boolean)state.func_177229_b((Property)field_176466_a)).booleanValue() && !((Boolean)state.func_177229_b((Property)field_176465_b)).booleanValue()) {
                world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)field_176466_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)field_176465_b, (Comparable)Boolean.valueOf(true)), 2);
                world.func_217378_a(null, 1008, pos, 0);
            } else if (!isPoweredSCBlock && ((Boolean)state.func_177229_b((Property)field_176466_a)).booleanValue() && ((Boolean)state.func_177229_b((Property)field_176465_b)).booleanValue()) {
                world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)field_176466_a, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176465_b, (Comparable)Boolean.valueOf(false)), 2);
                world.func_217378_a(null, 1014, pos, 0);
            } else if (isPoweredSCBlock != (Boolean)state.func_177229_b((Property)field_176465_b)) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176465_b, (Comparable)Boolean.valueOf(isPoweredSCBlock)), 2);
            }
        }
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int par5, int par6) {
        super.func_189539_a(state, world, pos, par5, par6);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null ? tileentity.func_145842_c(par5, par6) : false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SecurityCraftTileEntity().intersectsEntities();
    }
}

