/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedSnowyDirtBlock
extends SnowyDirtBlock
implements IReinforcedBlock,
IGrowable {
    private Block vanillaBlock;

    public ReinforcedSnowyDirtBlock(AbstractBlock.Properties properties, Block vB) {
        super(properties);
        this.vanillaBlock = vB;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing != Direction.UP) {
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }
        Block block = facingState.func_177230_c();
        return (BlockState)state.func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(block == Blocks.field_196604_cC || block == Blocks.field_150433_aE || block == SCContent.REINFORCED_SNOW_BLOCK.get()));
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        Block block = ctx.func_195991_k().func_180495_p(ctx.func_195995_a().func_177984_a()).func_177230_c();
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(block == Blocks.field_196604_cC || block == Blocks.field_150433_aE || block == SCContent.REINFORCED_SNOW_BLOCK.get()));
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (this == SCContent.REINFORCED_MYCELIUM.get()) {
            super.func_180655_c(state, world, pos, rand);
            if (rand.nextInt(10) == 0) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197596_G, (double)pos.func_177958_n() + (double)rand.nextFloat(), (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + (double)rand.nextFloat(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (type == PlantType.CAVE) {
            return state.func_224755_d(world, pos, Direction.UP);
        }
        if (type == PlantType.PLAINS) {
            return true;
        }
        if (type == PlantType.BEACH) {
            boolean isBeach = this.func_203417_a((ITag)SCTags.Blocks.REINFORCED_DIRT) || this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_RED_SAND.get();
            boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
            return isBeach && hasWater;
        }
        return false;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return this == SCContent.REINFORCED_GRASS_BLOCK.get() && world.func_180495_p(pos.func_177984_a()).isAir(world, pos.func_177984_a());
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return this == SCContent.REINFORCED_GRASS_BLOCK.get();
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        BlockPos posAbove = pos.func_177984_a();
        BlockState grass = Blocks.field_150349_c.func_176223_P();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos tempPos = posAbove;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    BlockState placeState;
                    BlockState tempState = world.func_180495_p(tempPos);
                    if (tempState.func_177230_c() == grass.func_177230_c() && rand.nextInt(10) == 0) {
                        ((IGrowable)grass.func_177230_c()).func_225535_a_(world, rand, tempPos, tempState);
                    }
                    if (!tempState.isAir((IBlockReader)world, tempPos)) continue block0;
                    if (rand.nextInt(8) == 0) {
                        List flowers = world.func_226691_t_(tempPos).func_242440_e().func_242496_b();
                        if (flowers.isEmpty()) continue block0;
                        ConfiguredFeature configuredfeature = (ConfiguredFeature)flowers.get(0);
                        FlowersFeature flowersfeature = (FlowersFeature)configuredfeature.field_222737_a;
                        placeState = flowersfeature.func_225562_b_(rand, tempPos, configuredfeature.func_242767_c());
                    } else {
                        placeState = grass;
                    }
                    if (!placeState.func_196955_c((IWorldReader)world, tempPos)) continue block0;
                    world.func_180501_a(tempPos, placeState, 3);
                    continue block0;
                }
                if (world.func_180495_p((tempPos = tempPos.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != this || world.func_180495_p(tempPos).func_235785_r_((IBlockReader)world, tempPos)) continue block0;
                ++j;
            }
        }
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_196382_a, vanillaState.func_177229_b((Property)field_196382_a));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)this)});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableTileEntity();
    }
}

