/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.versionchecker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.geforcemods.securitycraft.SecurityCraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SharedConstants;

public class VersionUpdateChecker {
    public static CompoundNBT getCompoundNBT() {
        CompoundNBT tag = new CompoundNBT();
        Gson gson = new GsonBuilder().create();
        try {
            URL updateURL = new URL("https://www.github.com/Geforce132/SecurityCraft/raw/master/Updates/" + SharedConstants.func_215069_a().getName() + ".json");
            BufferedReader in = new BufferedReader(new InputStreamReader(updateURL.openStream()));
            Update update = (Update)gson.fromJson((Reader)in, Update.class);
            if (update == null) {
                return null;
            }
            if (update.getVersion().equals("0.0.0") && update.getFileName().equals("test") || update.getVersion().equals(SecurityCraft.getVersion())) {
                return null;
            }
            tag.func_74778_a("newVersion", update.getVersion());
            tag.func_74778_a("updateUrl", update.getDownloadURL());
            tag.func_74778_a("changelog", update.getChangelog());
            tag.func_74778_a("newFileName", update.getFileName());
            tag.func_74757_a("isDirectLink", true);
        }
        catch (JsonSyntaxException | IOException e) {
            e.printStackTrace();
            return null;
        }
        return tag;
    }

    public static class Update {
        private String version;
        private String downloadURL;
        private String fileName;
        private String changelog;

        public Update(String version, String downloadURL, String fileName, String changelog) {
            this.version = version;
            this.downloadURL = downloadURL;
            this.fileName = fileName;
            this.changelog = changelog;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDownloadURL() {
            return this.downloadURL;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getChangelog() {
            return this.changelog;
        }
    }
}

