/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.waila;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

@WailaPlugin(value="securitycraft")
public class WailaDataProvider
implements IWailaPlugin,
IComponentProvider,
IEntityComponentProvider {
    public static final WailaDataProvider INSTANCE = new WailaDataProvider();
    public static final ResourceLocation SHOW_OWNER = new ResourceLocation("securitycraft", "showowner");
    public static final ResourceLocation SHOW_MODULES = new ResourceLocation("securitycraft", "showmodules");
    public static final ResourceLocation SHOW_PASSWORDS = new ResourceLocation("securitycraft", "showpasswords");
    public static final ResourceLocation SHOW_CUSTOM_NAME = new ResourceLocation("securitycraft", "showcustomname");

    public void register(IRegistrar registrar) {
        registrar.addConfig(SHOW_OWNER, true);
        registrar.addConfig(SHOW_MODULES, true);
        registrar.addConfig(SHOW_PASSWORDS, true);
        registrar.addConfig(SHOW_CUSTOM_NAME, true);
        registrar.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, IOwnable.class);
        registrar.registerStackProvider((IComponentProvider)INSTANCE, IOverlayDisplay.class);
        registrar.registerComponentProvider((IEntityComponentProvider)INSTANCE, TooltipPosition.BODY, SentryEntity.class);
    }

    public ItemStack getStack(IDataAccessor data, IPluginConfig config) {
        if (data.getBlock() instanceof IOverlayDisplay) {
            return ((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition());
        }
        return ItemStack.field_190927_a;
    }

    public void appendBody(List<ITextComponent> body, IDataAccessor data, IPluginConfig config) {
        BlockState disguisedBlockState;
        Block block = data.getBlock();
        boolean disguised = false;
        if (block instanceof DisguisableBlock && (disguisedBlockState = ((DisguisableBlock)block).getDisguisedBlockState((IBlockReader)data.getWorld(), data.getPosition())) != null) {
            disguised = true;
            block = disguisedBlockState.func_177230_c();
        }
        if (block instanceof IOverlayDisplay && !((IOverlayDisplay)block).shouldShowSCInfo(data.getWorld(), data.getBlockState(), data.getPosition())) {
            return;
        }
        TileEntity te = data.getTileEntity();
        if (config.get(SHOW_OWNER) && te instanceof IOwnable && block.getRegistryName().func_110624_b().equals("securitycraft")) {
            body.add((ITextComponent)ClientUtils.localize("waila.securitycraft:owner", ((IOwnable)te).getOwner().getName()));
        }
        if (disguised) {
            return;
        }
        if (config.get(SHOW_MODULES) && te instanceof IModuleInventory && (!(te instanceof IOwnable) || ((IOwnable)te).getOwner().isOwner(data.getPlayer()))) {
            if (!((IModuleInventory)te).getInsertedModules().isEmpty()) {
                body.add((ITextComponent)ClientUtils.localize("waila.securitycraft:equipped", new Object[0]));
            }
            for (ModuleType module : ((IModuleInventory)te).getInsertedModules()) {
                body.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(module.getTranslationKey())));
            }
        }
        if (config.get(SHOW_PASSWORDS) && te instanceof IPasswordProtected && !(te instanceof KeycardReaderTileEntity) && ((IOwnable)te).getOwner().isOwner(data.getPlayer())) {
            String password = ((IPasswordProtected)te).getPassword();
            body.add((ITextComponent)ClientUtils.localize("waila.securitycraft:password", password != null && !password.isEmpty() ? password : ClientUtils.localize("waila.securitycraft:password.notSet", new Object[0])));
        }
        if (config.get(SHOW_CUSTOM_NAME) && te instanceof INameable && ((INameable)te).canBeNamed()) {
            ITextComponent text = ((INameable)te).getCustomSCName();
            body.add((ITextComponent)ClientUtils.localize("waila.securitycraft:customName", ((INameable)te).hasCustomSCName() ? text : ClientUtils.localize("waila.securitycraft:customName.notSet", new Object[0])));
        }
    }

    public void appendBody(List<ITextComponent> body, IEntityAccessor data, IPluginConfig config) {
        Entity entity = data.getEntity();
        if (entity instanceof SentryEntity) {
            SentryEntity sentry = (SentryEntity)entity;
            SentryEntity.SentryMode mode = sentry.getMode();
            if (config.get(SHOW_OWNER)) {
                body.add((ITextComponent)ClientUtils.localize("waila.securitycraft:owner", sentry.getOwner().getName()));
            }
            if (config.get(SHOW_MODULES) && sentry.getOwner().isOwner(data.getPlayer()) && (!sentry.getWhitelistModule().func_190926_b() || !sentry.getDisguiseModule().func_190926_b())) {
                body.add((ITextComponent)ClientUtils.localize("waila.securitycraft:equipped", new Object[0]));
                if (!sentry.getWhitelistModule().func_190926_b()) {
                    body.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(ModuleType.WHITELIST.getTranslationKey())));
                }
                if (!sentry.getDisguiseModule().func_190926_b()) {
                    body.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(ModuleType.DISGUISE.getTranslationKey())));
                }
            }
            TranslationTextComponent modeDescription = ClientUtils.localize(mode.getModeKey(), new Object[0]);
            if (mode != SentryEntity.SentryMode.IDLE) {
                modeDescription.func_240702_b_("- ").func_230529_a_((ITextComponent)ClientUtils.localize(mode.getTargetKey(), new Object[0]));
            }
            body.add((ITextComponent)modeDescription);
        }
    }
}

