/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.SpecialDoorBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDoorBlock;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class UniversalOwnerChangerItem
extends Item {
    public UniversalOwnerChangerItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        return this.onItemUseFirst(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), stack, ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c);
    }

    public ActionResultType onItemUseFirst(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction side, double hitX, double hitY, double hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity te = world.func_175625_s(pos);
        String newOwner = stack.func_200301_q().getString();
        if (!world.field_72995_K) {
            boolean isDefault;
            if (!(te instanceof IOwnable)) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:universalOwnerChanger.cantChange", new Object[0]), TextFormatting.RED);
                return ActionResultType.FAIL;
            }
            Owner owner = ((IOwnable)te).getOwner();
            boolean bl = isDefault = owner.getName().equals("owner") && owner.getUUID().equals("ownerUUID");
            if (!owner.isOwner(player) && !isDefault) {
                if (!(block instanceof IBlockMine || te instanceof DisguisableTileEntity && !(((BlockItem)((DisguisableBlock)((DisguisableTileEntity)te).func_195044_w().func_177230_c()).getDisguisedStack((IBlockReader)world, pos).func_77973_b()).func_179223_d() instanceof DisguisableBlock))) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:universalOwnerChanger.notOwned", new Object[0]), TextFormatting.RED);
                }
                return ActionResultType.FAIL;
            }
            if (!stack.func_82837_s() && !isDefault) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), TextFormatting.RED);
                return ActionResultType.FAIL;
            }
            if (isDefault) {
                if (((Boolean)ConfigHandler.SERVER.allowBlockClaim.get()).booleanValue()) {
                    newOwner = player.func_200200_C_().getString();
                } else {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:universalOwnerChanger.noBlockClaiming", new Object[0]), TextFormatting.RED);
                    return ActionResultType.FAIL;
                }
            }
            boolean door = false;
            boolean updateTop = true;
            if (BlockUtils.getBlock((IBlockReader)world, pos) instanceof ReinforcedDoorBlock || BlockUtils.getBlock((IBlockReader)world, pos) instanceof SpecialDoorBlock) {
                door = true;
                ((IOwnable)world.func_175625_s(pos)).getOwner().set(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID", newOwner);
                if (BlockUtils.getBlock((IBlockReader)world, pos.func_177984_a()) instanceof ReinforcedDoorBlock || BlockUtils.getBlock((IBlockReader)world, pos.func_177984_a()) instanceof SpecialDoorBlock) {
                    ((IOwnable)world.func_175625_s(pos.func_177984_a())).getOwner().set(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID", newOwner);
                } else if (BlockUtils.getBlock((IBlockReader)world, pos.func_177977_b()) instanceof ReinforcedDoorBlock || BlockUtils.getBlock((IBlockReader)world, pos.func_177977_b()) instanceof SpecialDoorBlock) {
                    ((IOwnable)world.func_175625_s(pos.func_177977_b())).getOwner().set(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID", newOwner);
                    updateTop = false;
                }
            }
            if (te instanceof IOwnable) {
                ((IOwnable)te).getOwner().set(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID", newOwner);
            }
            world.func_73046_m().func_184103_al().func_148540_a((IPacket)te.func_189518_D_());
            if (door) {
                world.func_73046_m().func_184103_al().func_148540_a((IPacket)((OwnableTileEntity)world.func_175625_s(updateTop ? pos.func_177984_a() : pos.func_177977_b())).func_189518_D_());
            }
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), TextFormatting.GREEN);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack ownerChanger = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (!ownerChanger.func_82837_s()) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), TextFormatting.RED);
                return ActionResult.func_226251_d_((Object)ownerChanger);
            }
            if (hand == Hand.MAIN_HAND && player.func_184592_cb().func_77973_b() == SCContent.BRIEFCASE.get()) {
                ItemStack briefcase = player.func_184592_cb();
                if (BriefcaseItem.isOwnedBy(briefcase, player)) {
                    String newOwner = ownerChanger.func_200301_q().getString();
                    if (!briefcase.func_77942_o()) {
                        briefcase.func_77982_d(new CompoundNBT());
                    }
                    briefcase.func_77978_p().func_74778_a("owner", newOwner);
                    briefcase.func_77978_p().func_74778_a("ownerUUID", PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID");
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), TextFormatting.GREEN);
                    return ActionResult.func_226248_a_((Object)ownerChanger);
                }
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:universalOwnerChanger.briefcase.notOwned", new Object[0]), TextFormatting.RED);
            }
        }
        return ActionResult.func_226251_d_((Object)ownerChanger);
    }
}

