/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.text.TranslationTextComponent;

public class SCManualPage {
    private Item item;
    private TranslationTextComponent helpInfo;
    private BooleanSupplier configValue = () -> true;
    private String designedBy = "";
    private static final List<Item> EXPLOSIVES = Arrays.asList((Block)SCContent.BOUNCING_BETTY.get(), (Block)SCContent.CLAYMORE.get(), (Block)SCContent.COBBLESTONE_MINE.get(), (Block)SCContent.DIAMOND_ORE_MINE.get(), (Block)SCContent.DIRT_MINE.get(), (Block)SCContent.FURNACE_MINE.get(), (Block)SCContent.GRAVEL_MINE.get(), (Block)SCContent.IMS.get(), (Block)SCContent.SAND_MINE.get(), (Block)SCContent.STONE_MINE.get(), (Block)SCContent.TRACK_MINE.get(), (Block)SCContent.MINE.get(), (Block)SCContent.EMERALD_ORE_MINE.get(), (Block)SCContent.QUARTZ_ORE_MINE.get(), (Block)SCContent.REDSTONE_ORE_MINE.get(), (Block)SCContent.IRON_ORE_MINE.get(), (Block)SCContent.COAL_ORE_MINE.get(), (Block)SCContent.NETHER_GOLD_ORE_MINE.get(), (Block)SCContent.GILDED_BLACKSTONE_MINE.get(), (Block)SCContent.ANCIENT_DEBRIS_MINE.get(), (Block)SCContent.LAPIS_ORE_MINE.get(), (Block)SCContent.GOLD_ORE_MINE.get()).stream().map(Block::func_199767_j).collect(Collectors.toList());

    public SCManualPage(Item item, TranslationTextComponent helpInfo) {
        this.item = item;
        this.helpInfo = helpInfo;
        if (item == SCContent.KEYCARD_LVL_1.get()) {
            this.configValue = () -> (Boolean)ConfigHandler.SERVER.ableToCraftKeycard1.get();
        } else if (item == SCContent.KEYCARD_LVL_2.get()) {
            this.configValue = () -> (Boolean)ConfigHandler.SERVER.ableToCraftKeycard2.get();
        } else if (item == SCContent.KEYCARD_LVL_3.get()) {
            this.configValue = () -> (Boolean)ConfigHandler.SERVER.ableToCraftKeycard3.get();
        } else if (item == SCContent.KEYCARD_LVL_4.get()) {
            this.configValue = () -> (Boolean)ConfigHandler.SERVER.ableToCraftKeycard4.get();
        } else if (item == SCContent.KEYCARD_LVL_5.get()) {
            this.configValue = () -> (Boolean)ConfigHandler.SERVER.ableToCraftKeycard5.get();
        } else if (item == SCContent.LIMITED_USE_KEYCARD.get()) {
            this.configValue = () -> (Boolean)ConfigHandler.SERVER.ableToCraftLUKeycard.get();
        } else if (EXPLOSIVES.contains(item)) {
            this.configValue = () -> (Boolean)ConfigHandler.SERVER.ableToCraftMines.get();
        }
    }

    public Item getItem() {
        return this.item;
    }

    public TranslationTextComponent getHelpInfo() {
        return this.helpInfo;
    }

    public boolean isRecipeDisabled() {
        return !this.configValue.getAsBoolean();
    }

    public void setDesignedBy(String designedBy) {
        this.designedBy = designedBy;
    }

    public String getDesignedBy() {
        return this.designedBy;
    }
}

