/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetExplosiveState {
    private int x;
    private int y;
    private int z;
    private String state;

    public SetExplosiveState() {
    }

    public SetExplosiveState(int x, int y, int z, String state) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.state = state;
    }

    public static void encode(SetExplosiveState message, PacketBuffer buf) {
        buf.writeInt(message.x);
        buf.writeInt(message.y);
        buf.writeInt(message.z);
        buf.func_180714_a(message.state);
    }

    public static SetExplosiveState decode(PacketBuffer buf) {
        SetExplosiveState message = new SetExplosiveState();
        message.x = buf.readInt();
        message.y = buf.readInt();
        message.z = buf.readInt();
        message.state = buf.func_150789_c(0x1FFFFFFF);
        return message;
    }

    public static void onMessage(SetExplosiveState message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (BlockUtils.getBlock(player.field_70170_p, message.x, message.y, message.z) instanceof IExplosive) {
                if (message.state.equalsIgnoreCase("activate")) {
                    ((IExplosive)BlockUtils.getBlock(player.field_70170_p, message.x, message.y, message.z)).activateMine(player.field_70170_p, BlockUtils.toPos(message.x, message.y, message.z));
                } else if (message.state.equalsIgnoreCase("defuse")) {
                    ((IExplosive)BlockUtils.getBlock(player.field_70170_p, message.x, message.y, message.z)).defuseMine(player.field_70170_p, BlockUtils.toPos(message.x, message.y, message.z));
                } else if (message.state.equalsIgnoreCase("detonate")) {
                    ((IExplosive)BlockUtils.getBlock(player.field_70170_p, message.x, message.y, message.z)).explode(player.field_70170_p, BlockUtils.toPos(message.x, message.y, message.z));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

