/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.tileentity.KeypadChestTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetPassword {
    private String password;
    private int x;
    private int y;
    private int z;

    public SetPassword() {
    }

    public SetPassword(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.password = code;
    }

    public static void encode(SetPassword message, PacketBuffer buf) {
        buf.writeInt(message.x);
        buf.writeInt(message.y);
        buf.writeInt(message.z);
        buf.func_180714_a(message.password);
    }

    public static SetPassword decode(PacketBuffer buf) {
        SetPassword message = new SetPassword();
        message.x = buf.readInt();
        message.y = buf.readInt();
        message.z = buf.readInt();
        message.password = buf.func_150789_c(0x1FFFFFFF);
        return message;
    }

    public static void onMessage(SetPassword message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
            String password = message.password;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (SetPassword.getWorld((PlayerEntity)player).func_175625_s(pos) instanceof IPasswordProtected) {
                ((IPasswordProtected)SetPassword.getWorld((PlayerEntity)player).func_175625_s(pos)).setPassword(password);
                SetPassword.checkForAdjacentChest(pos, password, (PlayerEntity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void checkForAdjacentChest(BlockPos pos, String codeToSet, PlayerEntity player) {
        if (SetPassword.getWorld(player).func_175625_s(pos) instanceof KeypadChestTileEntity) {
            if (SetPassword.getWorld(player).func_175625_s(pos.func_177974_f()) instanceof KeypadChestTileEntity) {
                ((IPasswordProtected)SetPassword.getWorld(player).func_175625_s(pos.func_177974_f())).setPassword(codeToSet);
            } else if (SetPassword.getWorld(player).func_175625_s(pos.func_177976_e()) instanceof KeypadChestTileEntity) {
                ((IPasswordProtected)SetPassword.getWorld(player).func_175625_s(pos.func_177976_e())).setPassword(codeToSet);
            } else if (SetPassword.getWorld(player).func_175625_s(pos.func_177968_d()) instanceof KeypadChestTileEntity) {
                ((IPasswordProtected)SetPassword.getWorld(player).func_175625_s(pos.func_177968_d())).setPassword(codeToSet);
            } else if (SetPassword.getWorld(player).func_175625_s(pos.func_177978_c()) instanceof KeypadChestTileEntity) {
                ((IPasswordProtected)SetPassword.getWorld(player).func_175625_s(pos.func_177978_c())).setPassword(codeToSet);
            }
        }
    }

    private static World getWorld(PlayerEntity player) {
        return player.field_70170_p;
    }
}

