/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.RetinalScannerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.LightType;

public class RetinalScannerTileEntityRenderer
extends TileEntityRenderer<RetinalScannerTileEntity> {
    private static final float CORRECT_FACTOR = 0.0018181818f;

    public RetinalScannerTileEntityRenderer(TileEntityRendererDispatcher terd) {
        super(terd);
    }

    public void render(RetinalScannerTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        Direction direction = (Direction)te.func_195044_w().func_177229_b((Property)RetinalScannerBlock.FACING);
        if (!te.hasModule(ModuleType.DISGUISE) && direction != null) {
            matrix.func_227860_a_();
            switch (direction) {
                case NORTH: {
                    matrix.func_227861_a_(0.25, 0.0625, 0.0);
                    break;
                }
                case SOUTH: {
                    matrix.func_227861_a_(0.75, 0.0625, 1.0);
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    break;
                }
                case WEST: {
                    matrix.func_227861_a_(0.0, 0.0625, 0.75);
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                    break;
                }
                case EAST: {
                    matrix.func_227861_a_(1.0, 0.0625, 0.25);
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                    break;
                }
            }
            matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
            IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)RetinalScannerTileEntityRenderer.getSkinTexture(te.getPlayerProfile())));
            Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
            Matrix3f normalMatrix = matrix.func_227866_c_().func_227872_b_();
            Vector3i normalVector = direction.func_176730_m();
            BlockPos offsetPos = te.func_174877_v().func_177972_a(direction);
            combinedLight = LightTexture.func_228451_a_((int)te.func_145831_w().func_226658_a_(LightType.BLOCK, offsetPos), (int)te.func_145831_w().func_226658_a_(LightType.SKY, offsetPos));
            vertexBuilder.func_227888_a_(positionMatrix, 0.0018181818f, 0.0027272727f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.125f, 0.25f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(combinedLight).func_227887_a_(normalMatrix, (float)normalVector.func_177958_n(), (float)normalVector.func_177956_o(), (float)normalVector.func_177952_p()).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, 0.0018181818f, -0.5009091f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.125f, 0.125f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(combinedLight).func_227887_a_(normalMatrix, (float)normalVector.func_177958_n(), (float)normalVector.func_177956_o(), (float)normalVector.func_177952_p()).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, -0.5018182f, -0.5009091f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.25f, 0.125f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(combinedLight).func_227887_a_(normalMatrix, (float)normalVector.func_177958_n(), (float)normalVector.func_177956_o(), (float)normalVector.func_177952_p()).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, -0.5018182f, 0.0027272727f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.25f, 0.25f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(combinedLight).func_227887_a_(normalMatrix, (float)normalVector.func_177958_n(), (float)normalVector.func_177956_o(), (float)normalVector.func_177952_p()).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, 0.0018181818f, 0.0027272727f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.625f, 0.25f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(combinedLight).func_227887_a_(normalMatrix, (float)normalVector.func_177958_n(), (float)normalVector.func_177956_o(), (float)normalVector.func_177952_p()).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, 0.0018181818f, -0.5009091f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.625f, 0.125f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(combinedLight).func_227887_a_(normalMatrix, (float)normalVector.func_177958_n(), (float)normalVector.func_177956_o(), (float)normalVector.func_177952_p()).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, -0.5018182f, -0.5009091f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.75f, 0.125f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(combinedLight).func_227887_a_(normalMatrix, (float)normalVector.func_177958_n(), (float)normalVector.func_177956_o(), (float)normalVector.func_177952_p()).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, -0.5018182f, 0.0027272727f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.75f, 0.25f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(combinedLight).func_227887_a_(normalMatrix, (float)normalVector.func_177958_n(), (float)normalVector.func_177956_o(), (float)normalVector.func_177952_p()).func_181675_d();
            matrix.func_227865_b_();
        }
    }

    private static ResourceLocation getSkinTexture(@Nullable GameProfile profile) {
        if (((Boolean)ConfigHandler.SERVER.retinalScannerFace.get()).booleanValue() && profile != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)profile));
        }
        return DefaultPlayerSkin.func_177335_a();
    }
}

