/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.containers.InventoryScannerContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.InventoryScannerTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InventoryScannerScreen
extends ContainerScreen<InventoryScannerContainer> {
    private static final ResourceLocation REGULAR_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation ENHANCED_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_enhanced_gui.png");
    private InventoryScannerTileEntity tileEntity;
    private boolean owns = false;
    private boolean hasStorageModule = false;
    private ITextComponent infoString;
    private static final Style UNDERLINE = Style.field_240709_b_.func_240721_b_(TextFormatting.UNDERLINE);

    public InventoryScannerScreen(InventoryScannerContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.owns = this.tileEntity.getOwner().isOwner(inv.field_70458_d);
        this.hasStorageModule = this.tileEntity.hasModule(ModuleType.STORAGE);
        this.infoString = ClientUtils.localize("gui.securitycraft:invScan.emit_redstone", ClientUtils.localize("gui.securitycraft:invScan." + (this.tileEntity.hasModule(ModuleType.REDSTONE) ? "yes" : "no"), new Object[0])).func_240702_b_("\n\n").func_230529_a_((ITextComponent)ClientUtils.localize("gui.securitycraft:invScan.check_inv", ClientUtils.localize("gui.securitycraft:invScan." + (this.hasStorageModule ? "yes" : "no"), new Object[0])));
        this.field_146999_f = this.hasStorageModule ? 246 : 190;
        this.field_147000_g = 196;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        this.field_230712_o_.func_238418_a_((ITextProperties)this.infoString, this.field_147003_i + 8, this.field_147009_r + 40, 170, 0x404040);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.func_230457_a_(matrix, this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)ClientUtils.localize("gui.securitycraft:invScan.prohibitedItems", new Object[0]), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)ClientUtils.localize("gui.securitycraft:invScan.mode." + (this.tileEntity.getOwner().isOwner((PlayerEntity)this.field_230706_i_.field_71439_g) ? "admin" : "view"), new Object[0]).func_230530_a_(UNDERLINE), 112.0f, 6.0f, 0x404040);
        if (this.hasStorageModule && this.owns) {
            this.field_230712_o_.func_243248_b(matrix, (ITextComponent)ClientUtils.localize("gui.securitycraft:invScan.storage", new Object[0]), 188.0f, 18.0f, 0x404040);
        }
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)ClientUtils.localize("container.inventory", new Object[0]), 15.0f, (float)(this.field_147000_g - 93), 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.hasStorageModule && this.owns) {
            this.field_230706_i_.func_110434_K().func_110577_a(ENHANCED_INVENTORY);
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(REGULAR_INVENTORY);
        }
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g + 30);
    }
}

