/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ProjectorContainer;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.tileentity.ProjectorTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectorScreen
extends ContainerScreen<ProjectorContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/projector.png");
    private ProjectorTileEntity tileEntity;
    private TranslationTextComponent blockName;
    private TextHoverChecker[] hoverCheckers = new TextHoverChecker[5];
    private NamedSlider projectionWidthSlider;
    private NamedSlider projectionHeightSlider;
    private NamedSlider projectionRangeSlider;
    private NamedSlider projectionOffsetSlider;
    private TogglePictureButton toggleButton;
    private int sliderWidth = 120;

    public ProjectorScreen(ProjectorContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.blockName = ClientUtils.localize(this.tileEntity.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
        this.field_147000_g = 225;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int id = 0;
        int left = this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2;
        this.projectionWidthSlider = (NamedSlider)this.func_230480_a_((Widget)new NamedSlider((ITextComponent)ClientUtils.localize("gui.securitycraft:projector.width", this.tileEntity.getProjectionWidth()), (ITextComponent)this.blockName, id, left, this.field_147009_r + 47, this.sliderWidth, 20, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.width", ""), "", 1, 10, this.tileEntity.getProjectionWidth(), false, true, null, this::sliderReleased));
        this.projectionWidthSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((Button)this.projectionWidthSlider, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.width.description", new Object[0]));
        this.projectionHeightSlider = (NamedSlider)this.func_230480_a_((Widget)new NamedSlider((ITextComponent)ClientUtils.localize("gui.securitycraft:projector.height", this.tileEntity.getProjectionHeight()), (ITextComponent)this.blockName, id, left, this.field_147009_r + 68, this.sliderWidth, 20, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.height", ""), "", 1, 10, this.tileEntity.getProjectionHeight(), false, true, null, this::sliderReleased));
        this.projectionHeightSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((Button)this.projectionHeightSlider, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.height.description", new Object[0]));
        this.projectionRangeSlider = (NamedSlider)this.func_230480_a_((Widget)new NamedSlider((ITextComponent)ClientUtils.localize("gui.securitycraft:projector.range", this.tileEntity.getProjectionRange()), (ITextComponent)this.blockName, id, left, this.field_147009_r + 89, this.sliderWidth, 20, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.range", ""), "", 1, 30, this.tileEntity.getProjectionRange(), false, true, slider -> {
            if (this.tileEntity.isHorizontal()) {
                slider.func_238482_a_((ITextComponent)new StringTextComponent("").func_230529_a_(slider.dispString).func_240702_b_(Integer.toString((int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue) - 16)));
            }
        }, this::sliderReleased));
        this.projectionRangeSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((Button)this.projectionRangeSlider, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.range.description", new Object[0]));
        this.projectionOffsetSlider = (NamedSlider)this.func_230480_a_((Widget)new NamedSlider((ITextComponent)ClientUtils.localize("gui.securitycraft:projector.offset", this.tileEntity.getProjectionOffset()), (ITextComponent)this.blockName, id, left, this.field_147009_r + 110, this.sliderWidth, 20, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.offset", ""), "", -10, 10, this.tileEntity.getProjectionOffset(), false, true, null, this::sliderReleased));
        this.projectionOffsetSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((Button)this.projectionOffsetSlider, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.offset.description", new Object[0]));
        this.toggleButton = (TogglePictureButton)this.func_230480_a_((Widget)new TogglePictureButton(id, left, this.field_147009_r + 26, 20, 20, TEXTURE, new int[]{176, 192}, new int[]{0, 0}, 2, b -> {
            this.tileEntity.setHorizontal(!this.tileEntity.isHorizontal());
            this.projectionRangeSlider.updateSlider();
            SecurityCraft.channel.sendToServer((Object)new SyncProjector(this.tileEntity.func_174877_v(), this.tileEntity.isHorizontal() ? 1 : 0, SyncProjector.DataType.HORIZONTAL));
        }));
        this.toggleButton.setCurrentIndex(this.tileEntity.isHorizontal() ? 1 : 0);
        this.hoverCheckers[id++] = new TextHoverChecker((Button)this.toggleButton, Arrays.asList(ClientUtils.localize("gui.securitycraft:projector.vertical", new Object[0]), ClientUtils.localize("gui.securitycraft:projector.horizontal", new Object[0])));
        this.projectionRangeSlider.updateSlider();
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
        for (TextHoverChecker thc : this.hoverCheckers) {
            if (!thc.checkHover(mouseX, mouseY)) continue;
            this.func_238652_a_(matrix, thc.getName(), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.blockName, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.blockName) / 2), 6.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.projectionWidthSlider.dragging) {
            this.projectionWidthSlider.func_231048_c_(mouseX, mouseY, button);
        }
        if (this.projectionHeightSlider.dragging) {
            this.projectionWidthSlider.func_231048_c_(mouseX, mouseY, button);
        }
        if (this.projectionRangeSlider.dragging) {
            this.projectionRangeSlider.func_231048_c_(mouseX, mouseY, button);
        }
        if (this.projectionOffsetSlider.dragging) {
            this.projectionOffsetSlider.func_231048_c_(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public void sliderReleased(NamedSlider slider) {
        int data = 0;
        SyncProjector.DataType dataType = SyncProjector.DataType.INVALID;
        if (slider.id == this.projectionWidthSlider.id) {
            data = slider.getValueInt();
            this.tileEntity.setProjectionWidth(data);
            dataType = SyncProjector.DataType.WIDTH;
        } else if (slider.id == this.projectionHeightSlider.id) {
            data = slider.getValueInt();
            this.tileEntity.setProjectionHeight(data);
            dataType = SyncProjector.DataType.HEIGHT;
        } else if (slider.id == this.projectionRangeSlider.id) {
            data = slider.getValueInt();
            this.tileEntity.setProjectionRange(data);
            dataType = SyncProjector.DataType.RANGE;
        } else if (slider.id == this.projectionOffsetSlider.id) {
            data = slider.getValueInt();
            this.tileEntity.setProjectionOffset(data);
            dataType = SyncProjector.DataType.OFFSET;
        }
        SecurityCraft.channel.sendToServer((Object)new SyncProjector(this.tileEntity.func_174877_v(), data, dataType));
    }
}

