/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TogglePictureButton
extends ClickButton {
    private Block blockToRender;
    private Item itemToRender;
    private ResourceLocation textureLocation;
    private int[] u;
    private int[] v;
    private int currentIndex = 0;
    private final int toggleCount;

    public TogglePictureButton(int id, int xPos, int yPos, int width, int height, ResourceLocation texture, int[] textureX, int[] textureY, int toggleCount, Consumer<ClickButton> onClick) {
        super(id, xPos, yPos, width, height, "", onClick);
        if (textureX.length != toggleCount || textureY.length != toggleCount) {
            throw new RuntimeException("TogglePictureButton was set up incorrectly. Array lengths must match toggleCount!");
        }
        this.textureLocation = texture;
        this.u = textureX;
        this.v = textureY;
        this.toggleCount = toggleCount;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = mc.field_71466_p;
            ItemRenderer itemRenderer = mc.func_175599_af();
            int hoverState = !this.field_230693_o_ ? 0 : (!this.field_230692_n_ ? 1 : 2);
            mc.func_110434_K().func_110577_a(field_230687_i_);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, 0, 46 + hoverState * 20, this.field_230688_j_ / 2, this.field_230689_k_);
            this.func_238474_b_(matrix, this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230691_m_, 200 - this.field_230688_j_ / 2, 46 + hoverState * 20, this.field_230688_j_ / 2, this.field_230689_k_);
            if (this.blockToRender != null) {
                RenderSystem.enableRescaleNormal();
                itemRenderer.func_180450_b(new ItemStack((IItemProvider)this.blockToRender), this.field_230690_l_ + 2, this.field_230691_m_ + 3);
                itemRenderer.func_180453_a(font, new ItemStack((IItemProvider)this.blockToRender), this.field_230690_l_ + 2, this.field_230691_m_ + 3, "");
            } else if (this.itemToRender != null) {
                RenderSystem.enableRescaleNormal();
                itemRenderer.func_180450_b(new ItemStack((IItemProvider)this.itemToRender), this.field_230690_l_ + 2, this.field_230691_m_ + 2);
                itemRenderer.func_180453_a(font, new ItemStack((IItemProvider)this.itemToRender), this.field_230690_l_ + 2, this.field_230691_m_ + 2, "");
                RenderSystem.disableLighting();
            } else if (this.textureLocation != null) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(this.textureLocation);
                this.func_238474_b_(matrix, this.field_230690_l_ + 2, this.field_230691_m_ + 2, this.u[this.currentIndex], this.v[this.currentIndex], 16, 16);
            }
            int color = 0xE0E0E0;
            if (!this.field_230693_o_) {
                color = 0xA0A0A0;
            } else if (this.field_230692_n_) {
                color = 0xFFFFA0;
            }
            TogglePictureButton.func_238472_a_((MatrixStack)matrix, (FontRenderer)font, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)color);
        }
    }

    @Override
    public void func_230982_a_(double mouseX, double mouseY) {
        this.setCurrentIndex(this.currentIndex + 1);
        super.func_230982_a_(mouseX, mouseY);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int newIndex) {
        this.currentIndex = newIndex % this.toggleCount;
    }

    public Item getItemStack() {
        return this.blockToRender != null ? this.blockToRender.func_199767_j() : this.itemToRender;
    }
}

