/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.containers.InventoryScannerContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class InventoryScannerTileEntity
extends DisguisableTileEntity
implements IInventory,
INamedContainerProvider {
    private Option.BooleanOption horizontal = new Option.BooleanOption("horizontal", false);
    private Option.BooleanOption solidifyField = new Option.BooleanOption("solidifyField", false);
    private static final LazyOptional<IItemHandler> EMPTY_INVENTORY = LazyOptional.of(() -> new EmptyHandler());
    private NonNullList<ItemStack> inventoryContents = NonNullList.func_191197_a((int)37, (Object)ItemStack.field_190927_a);
    private boolean isProvidingPower;
    private int cooldown;

    public InventoryScannerTileEntity() {
        super(SCContent.teTypeInventoryScanner);
    }

    @Override
    public void func_73660_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (this.isProvidingPower) {
            this.isProvidingPower = false;
            BlockUtils.updateAndNotify(this.func_145831_w(), this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c(), 1, true);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        ListNBT list = tag.func_150295_c("Items", 10);
        this.inventoryContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventoryContents.size()) continue;
            this.inventoryContents.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)stackTag));
        }
        this.cooldown = tag.func_74762_e("cooldown");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).func_190926_b()) continue;
            CompoundNBT stackTag = new CompoundNBT();
            stackTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventoryContents.get(i)).func_77955_b(stackTag);
            list.add((Object)stackTag);
        }
        tag.func_218657_a("Items", (INBT)list);
        tag.func_74768_a("cooldown", this.cooldown);
        return tag;
    }

    public int func_70302_i_() {
        return 37;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.inventoryContents.get(index)).func_190926_b()) {
            if (((ItemStack)this.inventoryContents.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.inventoryContents.get(index);
                this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = ((ItemStack)this.inventoryContents.get(index)).func_77979_a(count);
            if (((ItemStack)this.inventoryContents.get(index)).func_190916_E() == 0) {
                this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.inventoryContents.get(slot);
    }

    public ItemStack getStackInSlotCopy(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void addItemToStorage(ItemStack stack) {
        ItemStack remainder = stack;
        for (int i = 10; i < this.getContents().size() && !(remainder = this.insertItem(i, remainder)).func_190926_b(); ++i) {
        }
    }

    public ItemStack insertItem(int slot, ItemStack stackToInsert) {
        if (stackToInsert.func_190926_b() || slot < 0 || slot >= this.getContents().size()) {
            return stackToInsert;
        }
        ItemStack slotStack = this.func_70301_a(slot);
        int limit = stackToInsert.func_77973_b().getItemStackLimit(stackToInsert);
        if (slotStack.func_190926_b()) {
            this.func_70299_a(slot, stackToInsert);
            return ItemStack.field_190927_a;
        }
        if (InventoryScannerFieldBlock.areItemStacksEqual(slotStack, stackToInsert) && slotStack.func_190916_E() < limit) {
            if (limit - slotStack.func_190916_E() >= stackToInsert.func_190916_E()) {
                slotStack.func_190920_e(slotStack.func_190916_E() + stackToInsert.func_190916_E());
                return ItemStack.field_190927_a;
            }
            ItemStack toInsert = stackToInsert.func_77946_l();
            ItemStack toReturn = toInsert.func_77979_a(slotStack.func_190916_E() + stackToInsert.func_190916_E() - limit);
            slotStack.func_190920_e(slotStack.func_190916_E() + toInsert.func_190916_E());
            return toReturn;
        }
        return stackToInsert;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return EMPTY_INVENTORY.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean hasCustomSCName() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public boolean shouldProvidePower() {
        return this.hasModule(ModuleType.REDSTONE) && this.isProvidingPower;
    }

    public void setShouldProvidePower(boolean isProvidingPower) {
        this.isProvidingPower = isProvidingPower;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventoryContents;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.inventoryContents = contents;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        InventoryScannerTileEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
        if (connectedScanner != null && !connectedScanner.hasModule(module)) {
            connectedScanner.insertModule(stack);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        InventoryScannerTileEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
        if (connectedScanner != null && connectedScanner.hasModule(module)) {
            connectedScanner.removeModule(module);
        }
        if (module == ModuleType.STORAGE) {
            int i;
            for (i = 10; i < this.func_70302_i_(); ++i) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)((ItemStack)this.getContents().get(i)));
            }
            if (connectedScanner != null) {
                for (i = 0; i < connectedScanner.getContents().size(); ++i) {
                    connectedScanner.getContents().set(i, (Object)ItemStack.field_190927_a);
                }
            }
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.WHITELIST, ModuleType.SMART, ModuleType.STORAGE, ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("horizontal")) {
            Option.BooleanOption bo = (Option.BooleanOption)option;
            InventoryScannerTileEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
            if (connectedScanner != null) {
                Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)InventoryScannerBlock.FACING);
                for (int i = 0; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
                    BlockPos offsetPos = this.field_174879_c.func_177967_a(facing, i);
                    BlockState state = this.field_145850_b.func_180495_p(offsetPos);
                    Block block = state.func_177230_c();
                    if (block == SCContent.INVENTORY_SCANNER_FIELD.get()) {
                        this.field_145850_b.func_175656_a(offsetPos, (BlockState)state.func_206870_a((Property)InventoryScannerFieldBlock.HORIZONTAL, (Comparable)bo.get()));
                        continue;
                    }
                    if (!state.isAir((IBlockReader)this.field_145850_b, offsetPos) && block != SCContent.INVENTORY_SCANNER_FIELD.get() && block != SCContent.INVENTORY_SCANNER.get() || block == SCContent.INVENTORY_SCANNER.get() && state.func_177229_b((Property)InventoryScannerBlock.FACING) == facing.func_176734_d()) break;
                }
                connectedScanner.setHorizontal((Boolean)bo.get());
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)bo.get()));
        } else if (option.getName().equals("solidifyField")) {
            Option.BooleanOption bo = (Option.BooleanOption)option;
            InventoryScannerTileEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
            connectedScanner.setSolidifyField((Boolean)bo.get());
        }
    }

    public void setHorizontal(boolean isHorizontal) {
        this.horizontal.setValue(isHorizontal);
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)Boolean.valueOf(isHorizontal)));
    }

    public boolean doesFieldSolidify() {
        return (Boolean)this.solidifyField.get();
    }

    public void setSolidifyField(boolean shouldSolidify) {
        this.solidifyField.setValue(shouldSolidify);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.horizontal, this.solidifyField};
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new InventoryScannerContainer(windowId, this.field_145850_b, this.field_174879_c, inv);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)SCContent.INVENTORY_SCANNER.get()).func_149739_a());
    }

    public void func_174888_l() {
        this.inventoryContents.clear();
    }

    public boolean func_191420_l() {
        return this.inventoryContents.isEmpty();
    }

    public ItemStack func_70304_b(int index) {
        return (ItemStack)this.inventoryContents.remove(index);
    }
}

