/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.KeycardReaderBlock;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkHooks;

public class KeycardReaderTileEntity
extends DisguisableTileEntity
implements IPasswordProtected,
INamedContainerProvider {
    private int passLV = 0;
    private boolean requiresExactKeycard = false;
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeycardReaderTileEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);

    public KeycardReaderTileEntity() {
        super(SCContent.teTypeKeycardReader);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("passLV", this.passLV);
        tag.func_74757_a("requiresExactKeycard", this.requiresExactKeycard);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.passLV = tag.func_74762_e("passLV");
        this.requiresExactKeycard = tag.func_74767_n("requiresExactKeycard");
    }

    public void setRequiresExactKeycard(boolean par1) {
        this.requiresExactKeycard = par1;
    }

    public boolean doesRequireExactKeycard() {
        return this.requiresExactKeycard;
    }

    @Override
    public void activate(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && BlockUtils.getBlock((IBlockReader)this.func_145831_w(), this.func_174877_v()) instanceof KeycardReaderBlock) {
            KeycardReaderBlock.activate(this.field_145850_b, this.func_174877_v(), (Integer)this.signalLength.get());
        }
    }

    @Override
    public void openPasswordGUI(PlayerEntity player) {
        if (this.getPassword() == null && player instanceof ServerPlayerEntity) {
            if (this.getOwner().isOwner(player)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
            } else {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)new StringTextComponent("SecurityCraft"), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
            }
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState blockState, PlayerEntity player, boolean isCodebreakerDisabled) {
        return false;
    }

    @Override
    public String getPassword() {
        return this.passLV == 0 ? null : String.valueOf(this.passLV);
    }

    @Override
    public void setPassword(String password) {
        this.passLV = Integer.parseInt(password);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.WHITELIST, ModuleType.BLACKLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new GenericTEContainer(SCContent.cTypeKeycardSetup, windowId, this.field_145850_b, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)SCContent.KEYCARD_READER.get()).func_149739_a());
    }
}

