/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.entity.BulletEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Explosion;

public class TrophySystemTileEntity
extends OwnableTileEntity
implements ITickableTileEntity {
    public static final int RANGE = 10;
    public static final int COOLDOWN_TIME = 8;
    public static final int RENDER_DISTANCE = 50;
    public Entity entityBeingTargeted = null;
    public int cooldown = 8;
    private final Random random = new Random();

    public TrophySystemTileEntity() {
        super(SCContent.teTypeTrophySystem);
    }

    public void func_73660_a() {
        if (this.entityBeingTargeted == null) {
            Entity target = this.getTarget();
            UUID shooterUUID = this.getShooterUUID(target);
            if (!(target == null || shooterUUID != null && shooterUUID.toString().equals(this.getOwner().getUUID()))) {
                this.entityBeingTargeted = target;
            }
        }
        if (this.entityBeingTargeted == null) {
            return;
        }
        if (!this.entityBeingTargeted.func_70089_S()) {
            this.resetTarget();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.destroyTarget();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(50.0);
    }

    private void destroyTarget() {
        this.entityBeingTargeted.func_70106_y();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_217385_a(null, this.entityBeingTargeted.func_226277_ct_(), this.entityBeingTargeted.func_226278_cu_(), this.entityBeingTargeted.func_226281_cx_(), 0.1f, Explosion.Mode.NONE);
        }
        this.resetTarget();
    }

    private void resetTarget() {
        this.cooldown = 8;
        this.entityBeingTargeted = null;
    }

    private Entity getTarget() {
        List<Object> potentialTargets = new ArrayList();
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(10.0, 10.0, 10.0);
        potentialTargets.addAll(this.field_145850_b.func_175647_a(AbstractArrowEntity.class, area, e -> !(e instanceof TridentEntity)));
        potentialTargets.addAll(this.field_145850_b.func_217357_a(DamagingProjectileEntity.class, area));
        potentialTargets.addAll(this.field_145850_b.func_217357_a(ShulkerBulletEntity.class, area));
        potentialTargets = potentialTargets.stream().filter(e -> !(e instanceof BulletEntity) || !((BulletEntity)((Object)e)).getOwner().equals(this.getOwner())).collect(Collectors.toList());
        if (potentialTargets.size() <= 0) {
            return null;
        }
        int target = this.random.nextInt(potentialTargets.size());
        return (Entity)potentialTargets.get(target);
    }

    public UUID getShooterUUID(Entity entity) {
        if (entity instanceof AbstractArrowEntity && ((AbstractArrowEntity)entity).func_234616_v_() != null) {
            return ((AbstractArrowEntity)entity).func_234616_v_().func_110124_au();
        }
        if (entity instanceof FireballEntity && ((FireballEntity)entity).func_234616_v_() != null) {
            return ((FireballEntity)entity).func_234616_v_().func_110124_au();
        }
        return null;
    }
}

