/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.command.uteamcore;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import info.u_team.u_team_core.util.world.WorldUtil;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class DimensionTeleportSubCommand {
    private static final String SUCCESS_TRANSLATION_STRING = "commands.uteamcore.dimteleport.success.";

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"dimteleport").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> DimensionTeleportSubCommand.execute((CommandSource)context.getSource(), EntityArgument.func_197097_b((CommandContext)context, (String)"targets"), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension")))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> DimensionTeleportSubCommand.execute((CommandSource)context.getSource(), EntityArgument.func_197097_b((CommandContext)context, (String)"targets"), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension"), Vec3Argument.func_197300_a((CommandContext)context, (String)"location")))).then(Commands.func_197056_a((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)360.0f)).then(Commands.func_197056_a((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)-90.0f, (float)90.0f)).executes(context -> DimensionTeleportSubCommand.execute((CommandSource)context.getSource(), EntityArgument.func_197097_b((CommandContext)context, (String)"targets"), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension"), Vec3Argument.func_197300_a((CommandContext)context, (String)"location"), FloatArgumentType.getFloat((CommandContext)context, (String)"yaw"), FloatArgumentType.getFloat((CommandContext)context, (String)"pitch"))))))));
    }

    private static int execute(CommandSource source, Collection<? extends Entity> targets, ServerWorld world) {
        targets.forEach(entity -> WorldUtil.teleportEntity(entity, world, entity.func_213303_ch()));
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.uteamcore.dimteleport.success.single", new Object[]{targets.iterator().next().func_145748_c_(), world.func_234923_W_().func_240901_a_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.uteamcore.dimteleport.success.multiple", new Object[]{targets.size(), world.func_234923_W_().func_240901_a_()}), true);
        }
        return 0;
    }

    private static int execute(CommandSource source, Collection<? extends Entity> targets, ServerWorld world, Vector3d pos) {
        targets.forEach(entity -> WorldUtil.teleportEntity(entity, world, pos));
        DimensionTeleportSubCommand.sendPositionInfo(source, targets, world, pos);
        return 0;
    }

    private static int execute(CommandSource source, Collection<? extends Entity> targets, ServerWorld world, Vector3d pos, float yaw, float pitch) {
        targets.forEach(entity -> WorldUtil.teleportEntity(entity, world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), yaw, pitch));
        DimensionTeleportSubCommand.sendPositionInfo(source, targets, world, pos);
        return 0;
    }

    private static void sendPositionInfo(CommandSource source, Collection<? extends Entity> targets, ServerWorld world, Vector3d pos) {
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.uteamcore.dimteleport.success.position.single", new Object[]{targets.iterator().next().func_145748_c_(), world.func_234923_W_().func_240901_a_(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.uteamcore.dimteleport.success.position.multiple", new Object[]{targets.size(), world.func_234923_W_().func_240901_a_(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c}), true);
        }
    }
}

