/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.container.FluidContainer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class FluidClickContainerMessage {
    private final int id;
    private final int slot;
    private final boolean shift;
    private final ItemStack stack;

    public FluidClickContainerMessage(int id, int slot, boolean shift, ItemStack stack) {
        this.id = id;
        this.slot = slot;
        this.shift = shift;
        this.stack = stack;
    }

    public static void encode(FluidClickContainerMessage message, PacketBuffer sendBuffer) {
        sendBuffer.writeByte(message.id);
        sendBuffer.writeShort(message.slot);
        sendBuffer.writeBoolean(message.shift);
        sendBuffer.writeItemStack(message.stack, false);
    }

    public static FluidClickContainerMessage decode(PacketBuffer sendBuffer) {
        byte id = sendBuffer.readByte();
        short slot = sendBuffer.readShort();
        boolean shift = sendBuffer.readBoolean();
        ItemStack stack = sendBuffer.func_150791_c();
        return new FluidClickContainerMessage(id, slot, shift, stack);
    }

    public static class Handler {
        public static void handle(FluidClickContainerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayerEntity player = context.getSender();
                Handler.getFluidContainer(player.field_71070_bA, message.id).ifPresent(container -> container.fluidSlotClick(player, message.slot, message.shift, message.stack));
            });
            context.setPacketHandled(true);
        }

        private static final Optional<FluidContainer> getFluidContainer(Container container, int id) {
            if (container instanceof FluidContainer && container.field_75152_c == id) {
                return Optional.of((FluidContainer)container);
            }
            return Optional.empty();
        }
    }
}

