/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import info.u_team.u_team_core.container.FluidContainer;
import info.u_team.u_team_core.container.FluidSlot;
import info.u_team.u_team_core.gui.renderer.FluidInventoryRenderer;
import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.FluidClickContainerMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class FluidContainerScreen<T extends Container>
extends ContainerScreen<T> {
    private static final FluidInventoryRenderer FLUID_RENDERER = new FluidInventoryRenderer();
    protected FluidInventoryRenderer fluidRenderer;
    protected FluidSlot hoveredFluidSlot;

    public FluidContainerScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.setFluidRenderer(FLUID_RENDERER);
    }

    protected void setFluidRenderer(FluidInventoryRenderer fluidRenderer) {
        this.fluidRenderer = fluidRenderer;
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.field_147002_h instanceof FluidContainer) {
            this.hoveredFluidSlot = null;
            FluidContainer fluidContainer = (FluidContainer)this.field_147002_h;
            for (int index = 0; index < fluidContainer.fluidSlots.size(); ++index) {
                FluidSlot fluidSlot = fluidContainer.fluidSlots.get(index);
                if (!fluidSlot.isEnabled()) continue;
                this.drawFluidSlot(matrixStack, fluidSlot);
                if (!this.isFluidSlotSelected(fluidSlot, mouseX, mouseY)) continue;
                this.hoveredFluidSlot = fluidSlot;
                int x = fluidSlot.getX();
                int y = fluidSlot.getY();
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int slotColor = this.getFluidSlotColor(index);
                this.func_238468_a_(matrixStack, x, y, x + 16, y + 16, slotColor, slotColor);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.enableDepthTest();
            }
        }
    }

    protected void func_230459_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.hoveredFluidSlot != null && !this.hoveredFluidSlot.getStack().isEmpty()) {
            this.func_243308_b(matrixStack, this.getTooltipFromFluid(this.hoveredFluidSlot), mouseX, mouseY);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        FluidSlot fluidSlot;
        if (button == 0 && (fluidSlot = this.getSelectedFluidSlot(mouseX, mouseY)) != null) {
            if (!this.field_213127_e.func_70445_o().func_190926_b()) {
                UCoreNetwork.NETWORK.sendToServer((Object)new FluidClickContainerMessage(this.field_147002_h.field_75152_c, fluidSlot.slotNumber, FluidContainerScreen.func_231173_s_(), this.field_213127_e.func_70445_o()));
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected void drawFluidSlot(MatrixStack matrixStack, FluidSlot fluidSlot) {
        this.fluidRenderer.drawFluid(matrixStack, fluidSlot.getX(), fluidSlot.getY(), fluidSlot.getStack());
    }

    protected boolean isFluidSlotSelected(FluidSlot fluidSlot, double mouseX, double mouseY) {
        return this.func_195359_a(fluidSlot.getX(), fluidSlot.getY(), 16, 16, mouseX, mouseY);
    }

    public int getFluidSlotColor(int index) {
        return super.getSlotColor(index);
    }

    public List<ITextComponent> getTooltipFromFluid(FluidSlot fluidSlot) {
        FluidStack stack = fluidSlot.getStack();
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(stack.getDisplayName());
        list.add((ITextComponent)new StringTextComponent(stack.getAmount() + " / " + fluidSlot.getSlotCapacity()).func_240699_a_(TextFormatting.GRAY));
        if (this.field_230706_i_.field_71474_y.field_82882_x) {
            list.add((ITextComponent)new StringTextComponent(ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)stack.getFluid()).toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        return list;
    }

    private FluidSlot getSelectedFluidSlot(double mouseX, double mouseY) {
        if (this.field_147002_h instanceof FluidContainer) {
            FluidContainer fluidContainer = (FluidContainer)this.field_147002_h;
            for (int index = 0; index < fluidContainer.fluidSlots.size(); ++index) {
                FluidSlot fluidSlot = fluidContainer.fluidSlots.get(index);
                if (!this.isFluidSlotSelected(fluidSlot, mouseX, mouseY) || !fluidSlot.isEnabled()) continue;
                return fluidSlot;
            }
        }
        return null;
    }
}

