/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import info.u_team.u_team_core.util.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class GuiUtil {
    public static void drawContainerBorder(MatrixStack matrixStack, int x, int y, int width, int height) {
        int darkColor = -13158601;
        int mediumColor = -7631989;
        int brightColor = -1;
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + width - 1), (int)(y + 1), (int)-13158601);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + 1), (int)(y + height - 1), (int)-13158601);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + width - 1), (int)y, (int)(x + width), (int)(y + 1), (int)-7631989);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)(y + height - 1), (int)(x + 1), (int)(y + height), (int)-7631989);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 1), (int)(y + height), (int)(x + width - 1), (int)(y + height - 1), (int)-1);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height), (int)-1);
    }

    public static void clearColor() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawContinuousTexturedBox(MatrixStack matrixStack, ResourceLocation location, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel, RGBA color) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
        GuiUtil.drawContinuousTexturedBox(matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder, zLevel, color);
    }

    public static void drawContinuousTexturedBox(MatrixStack matrixStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel, RGBA color) {
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        GuiUtil.addTexturedColoredRect(bufferBuilder, matrixStack, x, y, u, v, 0.00390625f, 0.00390625f, leftBorder, topBorder, zLevel, color);
        GuiUtil.addTexturedColoredRect(bufferBuilder, matrixStack, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, 0.00390625f, 0.00390625f, rightBorder, topBorder, zLevel, color);
        GuiUtil.addTexturedColoredRect(bufferBuilder, matrixStack, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, 0.00390625f, 0.00390625f, leftBorder, bottomBorder, zLevel, color);
        GuiUtil.addTexturedColoredRect(bufferBuilder, matrixStack, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, 0.00390625f, 0.00390625f, rightBorder, bottomBorder, zLevel, color);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtil.addTexturedColoredRect(bufferBuilder, matrixStack, x + leftBorder + i * fillerWidth, y, u + leftBorder, v, 0.00390625f, 0.00390625f, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel, color);
            GuiUtil.addTexturedColoredRect(bufferBuilder, matrixStack, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, 0.00390625f, 0.00390625f, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel, color);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtil.addTexturedColoredRect(bufferBuilder, matrixStack, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, 0.00390625f, 0.00390625f, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel, color);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtil.addTexturedColoredRect(bufferBuilder, matrixStack, x, y + topBorder + j * fillerHeight, u, v + topBorder, 0.00390625f, 0.00390625f, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel, color);
            GuiUtil.addTexturedColoredRect(bufferBuilder, matrixStack, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, 0.00390625f, 0.00390625f, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel, color);
        }
        tessellator.func_78381_a();
    }

    public static void addTexturedColoredRect(BufferBuilder bufferBuilder, MatrixStack matrixStack, int x, int y, int u, int v, float uScale, float vScale, int width, int height, float zLevel, RGBA color) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        bufferBuilder.func_227888_a_(matrix, (float)x, (float)(y + height), zLevel).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_225583_a_((float)u * uScale, (float)(v + height) * vScale).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(x + width), (float)(y + height), zLevel).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_225583_a_((float)(u + width) * uScale, (float)(v + height) * vScale).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(x + width), (float)y, zLevel).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_225583_a_((float)(u + width) * uScale, (float)v * vScale).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)x, (float)y, zLevel).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_225583_a_((float)u * uScale, (float)v * vScale).func_181675_d();
    }

    public static void drawTexturedColoredQuad(MatrixStack matrixStack, int x, int y, int width, int height, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, float zLevel, RGBA color) {
        GuiUtil.drawTexturedColoredQuad(matrixStack, x, x + width, y, y + height, uOffset / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, vOffset / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, zLevel, color);
    }

    public static void drawTexturedColoredQuad(MatrixStack matrixStack, int x, int y, int width, int height, TextureAtlasSprite sprite, float zLevel, RGBA color) {
        GuiUtil.drawTexturedColoredQuad(matrixStack, x, x + width, y, y + height, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h(), zLevel, color);
    }

    public static void drawTexturedColoredQuad(MatrixStack matrixStack, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2, float zLevel, RGBA color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        GuiUtil.addTexturedColoredQuad(bufferBuilder, matrixStack, x1, x2, y1, y2, u1, u2, v1, v2, zLevel, color);
        tessellator.func_78381_a();
    }

    public static void addTexturedColoredQuad(BufferBuilder bufferBuilder, MatrixStack matrixStack, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2, float zLevel, RGBA color) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        GuiUtil.addVertexColor(bufferBuilder.func_227888_a_(matrix, (float)x1, (float)y2, zLevel), color).func_225583_a_(u1, v2).func_181675_d();
        GuiUtil.addVertexColor(bufferBuilder.func_227888_a_(matrix, (float)x2, (float)y2, zLevel), color).func_225583_a_(u2, v2).func_181675_d();
        GuiUtil.addVertexColor(bufferBuilder.func_227888_a_(matrix, (float)x2, (float)y1, zLevel), color).func_225583_a_(u2, v1).func_181675_d();
        GuiUtil.addVertexColor(bufferBuilder.func_227888_a_(matrix, (float)x1, (float)y1, zLevel), color).func_225583_a_(u1, v1).func_181675_d();
    }

    public static IVertexBuilder addVertexColor(IVertexBuilder builder, RGBA color) {
        return builder.func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }
}

