/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.api.gui.IBackgroundColorProvider;
import info.u_team.u_team_core.api.gui.IPerspectiveRenderable;
import info.u_team.u_team_core.api.gui.IScaleProvider;
import info.u_team.u_team_core.api.gui.ITextColorProvider;
import info.u_team.u_team_core.api.gui.ITextProvider;
import info.u_team.u_team_core.api.gui.ITextureProvider;
import info.u_team.u_team_core.util.GuiUtil;
import info.u_team.u_team_core.util.RenderUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class WidgetUtil {
    public static boolean isHovered(Widget widget) {
        return widget.field_230692_n_;
    }

    public static <T extends Widget & IBackgroundColorProvider> void renderButtonLikeWidget(T widget, ITextureProvider textureProvider, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderUtil.enableBlend();
        RenderUtil.defaultBlendFunc();
        GuiUtil.drawContinuousTexturedBox(matrixStack, textureProvider.getTexture(), widget.field_230690_l_, widget.field_230691_m_, textureProvider.getU(), textureProvider.getV(), widget.field_230688_j_, widget.field_230689_k_, textureProvider.getWidth(), textureProvider.getHeight(), 2, 3, 2, 2, widget.func_230927_p_(), ((IBackgroundColorProvider)widget).getCurrentBackgroundColor(matrixStack, mouseY, mouseY, partialTicks));
        RenderUtil.disableBlend();
        Minecraft minecraft = Minecraft.func_71410_x();
        ((IPerspectiveRenderable)widget).renderBackground(matrixStack, minecraft, mouseX, mouseY, partialTicks);
        ((IPerspectiveRenderable)widget).renderForeground(matrixStack, minecraft, mouseX, mouseY, partialTicks);
    }

    public static <T extends Widget> void renderText(T widget, MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        FontRenderer fontRenderer = minecraft.field_71466_p;
        ITextComponent message = ((ITextProvider)widget).getCurrentText();
        if (message != StringTextComponent.field_240750_d_) {
            int messageWidth = fontRenderer.func_238414_a_((ITextProperties)message);
            int ellipsisWidth = fontRenderer.func_78256_a("...");
            if (messageWidth > widget.field_230688_j_ - 6 && messageWidth > ellipsisWidth) {
                message = new StringTextComponent(fontRenderer.func_238417_a_((ITextProperties)message, widget.field_230688_j_ - 6 - ellipsisWidth).getString() + "...");
            }
            float xStart = widget.field_230690_l_ + widget.field_230688_j_ / 2 - messageWidth / 2;
            float yStart = widget.field_230691_m_ + (widget.field_230689_k_ - 8) / 2;
            fontRenderer.func_243246_a(matrixStack, message, xStart, yStart, ((ITextColorProvider)widget).getCurrentTextColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB());
        }
    }

    public static <T extends Widget & IScaleProvider> void renderScaledText(T widget, MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        float scale = ((IScaleProvider)widget).getCurrentScale(matrixStack, mouseX, mouseY, partialTicks);
        if (scale == 1.0f) {
            WidgetUtil.renderText(widget, matrixStack, minecraft, mouseX, mouseY, partialTicks);
        } else {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            ITextComponent message = ((ITextProvider)widget).getCurrentText();
            if (message != StringTextComponent.field_240750_d_) {
                int messageWidth = MathHelper.func_76123_f((float)(scale * (float)fontRenderer.func_238414_a_((ITextProperties)message)));
                int ellipsisWidth = MathHelper.func_76123_f((float)(scale * (float)fontRenderer.func_78256_a("...")));
                if (messageWidth > widget.field_230688_j_ - 6 && messageWidth > ellipsisWidth) {
                    message = new StringTextComponent(fontRenderer.func_238417_a_((ITextProperties)message, widget.field_230688_j_ - 6 - ellipsisWidth).getString() + "...");
                }
                float positionFactor = 1.0f / scale;
                float xStart = (float)(widget.field_230690_l_ + widget.field_230688_j_ / 2 - messageWidth / 2) * positionFactor;
                float yStart = (float)(widget.field_230691_m_ + (int)((float)widget.field_230689_k_ - 8.0f * scale) / 2) * positionFactor;
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(scale, scale, 0.0f);
                fontRenderer.func_243246_a(matrixStack, message, xStart, yStart, ((ITextColorProvider)widget).getCurrentTextColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB());
                matrixStack.func_227865_b_();
            }
        }
    }

    public static void renderTooltips(List<Widget> widgets, MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        widgets.forEach(widget -> {
            if (widget instanceof IPerspectiveRenderable) {
                ((IPerspectiveRenderable)widget).renderToolTip(matrixStack, minecraft, mouseX, mouseY, partialTicks);
            } else {
                widget.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        });
    }
}

