/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.internal;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.internal.IPropertyAdapter;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;

public class ForgeTransmogrifier {
    public static Property<?> transmogToWorldEditProperty(net.minecraft.state.Property<?> property) {
        if (property instanceof BooleanProperty) {
            return new com.sk89q.worldedit.registry.state.BooleanProperty(property.func_177701_a(), (List<Boolean>)ImmutableList.copyOf((Collection)((BooleanProperty)property).func_177700_c()));
        }
        if (property instanceof IntegerProperty) {
            return new com.sk89q.worldedit.registry.state.IntegerProperty(property.func_177701_a(), (List<Integer>)ImmutableList.copyOf((Collection)((IntegerProperty)property).func_177700_c()));
        }
        if (property instanceof DirectionProperty) {
            return new DirectionalProperty(property.func_177701_a(), ((DirectionProperty)property).func_177700_c().stream().map(ForgeAdapter::adaptEnumFacing).collect(Collectors.toList()));
        }
        if (property instanceof net.minecraft.state.EnumProperty) {
            return new EnumProperty(property.func_177701_a(), ((net.minecraft.state.EnumProperty)property).func_177700_c().stream().map(x -> ((IStringSerializable)x).func_176610_l()).collect(Collectors.toList()));
        }
        return new IPropertyAdapter(property);
    }

    public static Map<Property<?>, Object> transmogToWorldEditProperties(BlockType block, Map<net.minecraft.state.Property<?>, Comparable<?>> mcProps) {
        TreeMap props = new TreeMap(Comparator.comparing(Property::getName));
        for (Map.Entry<net.minecraft.state.Property<?>, Comparable<?>> prop : mcProps.entrySet()) {
            Object value = prop.getValue();
            if (prop.getKey() instanceof DirectionProperty) {
                value = ForgeAdapter.adaptEnumFacing((Direction)value);
            } else if (prop.getKey() instanceof net.minecraft.state.EnumProperty) {
                value = ((IStringSerializable)value).func_176610_l();
            }
            props.put(block.getProperty(prop.getKey().func_177701_a()), value);
        }
        return props;
    }

    private static net.minecraft.block.BlockState transmogToMinecraftProperties(StateContainer<Block, net.minecraft.block.BlockState> stateContainer, net.minecraft.block.BlockState newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            net.minecraft.state.Property property = stateContainer.func_185920_a(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof DirectionProperty) {
                com.sk89q.worldedit.util.Direction dir = (com.sk89q.worldedit.util.Direction)((Object)value);
                value = ForgeAdapter.adapt(dir);
            } else if (property instanceof net.minecraft.state.EnumProperty) {
                String enumName = (String)((Object)value);
                value = (Comparable)((Object)((net.minecraft.state.EnumProperty)property).func_185929_b((String)((Object)value)).orElseGet(() -> {
                    throw new IllegalStateException("Enum property " + property.func_177701_a() + " does not contain " + enumName);
                }));
            }
            newState = (net.minecraft.block.BlockState)newState.func_206870_a(property, value);
        }
        return newState;
    }

    public static net.minecraft.block.BlockState transmogToMinecraft(BlockState blockState) {
        Block mcBlock = ForgeAdapter.adapt(blockState.getBlockType());
        net.minecraft.block.BlockState newState = mcBlock.func_176223_P();
        Map<Property<?>, Object> states = blockState.getStates();
        return ForgeTransmogrifier.transmogToMinecraftProperties((StateContainer<Block, net.minecraft.block.BlockState>)mcBlock.func_176194_O(), newState, states);
    }

    public static BlockState transmogToWorldEdit(net.minecraft.block.BlockState blockState) {
        BlockType blockType = ForgeAdapter.adapt(blockState.func_177230_c());
        return blockType.getState(ForgeTransmogrifier.transmogToWorldEditProperties(blockType, blockState.func_206871_b()));
    }

    private ForgeTransmogrifier() {
    }
}

