/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal;

import com.sk89q.worldedit-fabric.slf4j.Logger;
import com.sk89q.worldedit-fabric.slf4j.LoggerFactory;
import com.sk89q.worldedit.event.platform.ConfigurationLoadEvent;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class SchematicsEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematicsEventListener.class);

    @Subscribe
    public void onConfigLoad(ConfigurationLoadEvent event) {
        Path config = event.getConfiguration().getWorkingDirectory().toPath();
        try {
            Files.createDirectories(config.resolve(event.getConfiguration().saveDir), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            LOGGER.debug("Schematic directory exists as file. Possible symlink.", e);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create schematics directory", e);
        }
    }
}

